package com.bxm.adsmanager.dal.mapper.adflowpackage;

import com.bxm.adsmanager.model.dao.adflowpackage.AdFlowPackage;
import com.bxm.adsmanager.model.dto.AdFlowPackageDto;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <h3></h3>
 * 
 * @author 代拉拉
 * @since V1.0.0, 2017/12/14 19:11
 */
@Repository
public interface AdFlowPackageMapper {

    /**
     * @description 批量插入数据
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param list
     * @return void
     */
    void insert(AdFlowPackage adFlowPackage);

    /**
     * @description 根据条件获取数量
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param list
     * @return void
     */
    Integer getTotalCount(Map<String, Object> map);

    /**
     * @description 根据条件获取数据
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param list
     * @return void
     */
    List<AdFlowPackage> getListByMap(Map<String, Object> map);


    /**
     * 查询其广告位
     *
     * @author 阿导
     * @time 2018/4/23
     * @CopyRight 杭州微财科技有限公司
     * @param packageIds
     * @return java.util.List<com.bxm.adsmanager.model.dao.adflowpackage.AdFlowPackage>
     */
    List<AdFlowPackage> getPosition(@Param("packageIds") ArrayList<Long> packageIds);

    /**
     * @description 根据条件获取数据
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param list
     * @return void
     */
    List<AdFlowPackage> findPositionIdsById(Map<String, Object> map);

    /**
     * @description 根据id
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param list
     * @return void
     */
    AdFlowPackage findById(@Param("id") String id);

    /**
     * @description 根据id
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param list
     * @return void
     */
    void update(AdFlowPackageDto adTicketPopupDto);

    /**
     * @description 查找所有创建人姓名
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param list
     * @return void
     */
    List<String> findAllPackageName();

    /**
     * @description 根据id删除流量包
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param list
     * @return void
     */
    void delete(@Param("id") Long id);


    /**
     * Description: 根据ID集合 批量查询流量包
     * JDK version used:<JDK1.8>
     * Create Date：2018/12/11 17:25

     * @param ids id集合
     * @return java.util.List<com.bxm.adsmanager.model.dao.adflowpackage.AdFlowPackage>
     * @author hxpeng
     */
    List<AdFlowPackage> findByIds(@Param("ids") List<Long> ids);

    /**
     * 获取指定ID的最新修改时间
     * @param packageIds
     * @return
     */
    Date getMaxModifyTimeByIds(@Param("packageIds") List<Long> packageIds);
}
