package com.bxm.adsmanager.dal.mapper.adflowpackage;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import com.bxm.adsmanager.model.dao.adflowpackage.AdTicketFlowPackageConf;
import com.bxm.adsmanager.model.vo.AdFlowPackageNewVo;

/**
 * <h3>广告券的流量包数据</h3>
 * 
 * @author 代拉拉
 * @since V1.0.0, 2017/12/14 19:11
 */
@Repository
public interface AdTicketFlowPackageMapper {

    /**
     * @description 批量插入数据
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param adTicketFlowPackageConfList
     * @return void
     */
    void insert(List<AdTicketFlowPackageConf> adTicketFlowPackageConfList);

    /**
     * @description 删除指定广告券的流量包数据
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param ticketId
     * @return void
     */
    void deleteByTicketId(@Param("ticketId") Long ticketId);

    int deleteByIds(@Param("ids") List<Long> ids);

    /**
     * @description 删除指定流量包和指定广告券的流量包数据
     * @author zhengwangeng
     * @time 2019/11/5
     * @CopyRight 杭州微财科技有限公司
     * @param flowPackageId
     * @param ticketIds  广告券ID集合
     * @return void
     */
    void deleteByFlowPackageIdAndTicketIds(@Param("flowPackageId")Long flowPackageId, @Param("ticketIds")List<Long> ticketIds);

    /**
     * Description: 根据类型和券ID 删除
     * JDK version used:<JDK1.8>
     * Create Date：2018/12/6 10:43
     * @param ticketId 券ID
     * @param type 类型
     * @return void
     * @author hxpeng
     */
    void deleteByTicketIdAndType(@Param("ticketId") Long ticketId, @Param("type") Integer type);

    /**
     * @description根据礼券id和流量包id查找数据是否存在
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param flowPackageId
     * @return void
     */
    Integer getCountByparam(@Param("flowPackageId") String flowPackageId);

    /**
     * @description 根据礼券id查找流量包列表
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param ticketId
     * @return void
     */
    List<AdTicketFlowPackageConf> findAll(@Param("ticketId") String ticketId);

    /**
     * @description根据礼券id和流量包id查找入口id
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param map
     * @return void
     */
    List<AdTicketFlowPackageConf> getListByparam(Map<String, Object> map);

    /**
     * 查询广告流量包信息
     *
     * @author 阿导
     * @time 2018/4/20
     * @CopyRight 杭州微财科技有限公司
     * @param packageIds 流量包集合
     * @return java.util.List<com.bxm.adsmanager.model.vo.AdFlowPackageNewVo>
     */
    List<AdFlowPackageNewVo> findByAdFlowByConditionOne(@Param("packageIds")List<Long> packageIds);
    /**
     * 查询广告流量包信息
     *
     * @author 阿导
     * @time 2018/4/20
     * @CopyRight 杭州微财科技有限公司
     * @param ticketId 广告券 ID
     * @param type 查询类型
     * @return java.util.List<com.bxm.adsmanager.model.vo.AdFlowPackageNewVo>
     */
    List<AdFlowPackageNewVo> findByAdFlowByConditionTwo(@Param("ticketId")Long ticketId, @Param("type") Integer type);

    /**
     * 查询所有的流量包限制
     *
     * @author 阿导
     * @time 2018/4/23
     * @CopyRight 杭州微财科技有限公司
     * @param
     * @return java.util.List<com.bxm.adsmanager.model.vo.AdFlowPackageNewVo>
     */
    List<AdFlowPackageNewVo> findAdFlowAll();

    /**
     * 查询广告券出价，便于数据同步
     *
     * @author 阿导
     * @time 2018/4/23
     * @CopyRight 杭州微财科技有限公司
     * @param ticketIds
     * @return java.util.List<com.bxm.adsmanager.model.vo.AdFlowPackageNewVo>
     */
    List<AdFlowPackageNewVo>  findTicketPrice(@Param("ticketIds") ArrayList<Long> ticketIds);

    List<AdTicketFlowPackageConf> findByAdFlowByTicketId(@Param("ticketId")Long ticketId, @Param("type") Integer type);

    /**
     * 根据礼券的ID集查询礼券的最高出价流量包
     *
     * @param packageId
     * @return com.bxm.adsmanager.model.dao.adflowpackage.AdTicketFlowPackageConf
     * @throws
     * @author kk.xie
     * @date 2018/7/4 15:42
     */
    AdTicketFlowPackageConf selectPackageById( @Param("packageId") String packageId);


    List<AdTicketFlowPackageConf> findByAdFlowConfByTicketId(@Param("ticketId")Long ticketId, @Param("type") Integer type);

}
