package com.bxm.adsmanager.dal.mapper.adflowpackage;

import java.util.List;

import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import com.bxm.adsmanager.model.dao.adflowpackage.AdTicketFlowPackageOfferRelation;
import com.bxm.adsmanager.model.vo.AdTicketFlowPackageOfferRelationVo;


@Repository
public interface AdTicketFlowPackageOfferRelationMapper {
    int deleteByPrimaryKey(Long id);

    int insert(AdTicketFlowPackageOfferRelation record);

    int insertSelective(AdTicketFlowPackageOfferRelation record);

    AdTicketFlowPackageOfferRelation selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(AdTicketFlowPackageOfferRelation record);

    int updateByPrimaryKey(AdTicketFlowPackageOfferRelation record);

    /**
     * <p>批量新增</p>
     */
    int insertBatch(List<AdTicketFlowPackageOfferRelation> recordList);

    /**
     * <p>批量更新</p>
     */
    int updateBatch(List<AdTicketFlowPackageOfferRelation> recordList);

    /**
     * <p>批量删除</p>
     */
    int deleteBatch(List<Long> idList);

    /**
     * <p>根据配置ID删除</p>
     */
    int deleteByFlowPackageOfferConfId(@Param("flowPackageOfferConfId") Long flowPackageOfferConfId);

    /**
     * <p>根据配置ID查找流量包出价列表</p>
     */
    List<AdTicketFlowPackageOfferRelation> findByFlowPackageOfferConfId(@Param("flowPackageOfferConfId") Long flowPackageOfferConfId);

    /**
     * <p>根据广告券ID查找流量包出价列表</p>
     */
    List<AdTicketFlowPackageOfferRelationVo> findFlowPackageByTicketId(@Param("ticketId") Long ticketId);

    /**
     * @description 根据流量包ID和指定的广告券ID列表查询流量包出价列表
     * @author zhengwangeng
     * @time 2019/11/5
     * @CopyRight 杭州微财科技有限公司
     * @param flowPackageId 流量包ID
     * @param ticketIds  广告券ID集合
     * @return void
     */
    List<AdTicketFlowPackageOfferRelation> findByFlowPackageIdAndTicketIds(@Param("flowPackageId")Long flowPackageId, @Param("ticketIds")List<Long> ticketIds);
}