package com.bxm.adsmanager.dal.mapper.adkeeper;

import com.bxm.adsmanager.model.dao.adkeeper.Activity;
import com.bxm.adsmanager.model.dao.adkeeper.ActivityWithBLOBs;
import com.bxm.adsmanager.model.dto.InfoActivityMsgDto;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository
public interface ActivityMapper {
    int deleteByPrimaryKey(Long activityid);

    int insert(ActivityWithBLOBs record);

    int insertSelective(ActivityWithBLOBs record);

    ActivityWithBLOBs selectByPrimaryKey(Long activityid);

    int updateByPrimaryKeySelective(ActivityWithBLOBs record);

    int updateByPrimaryKeyWithBLOBs(ActivityWithBLOBs record);

    int updateByPrimaryKey(Activity record);

    /**
     * 查询所有的活动
     * @return
     */
    List<ActivityWithBLOBs> findList(Map<String,Object> map);

    /**
     * 通过关键字模糊搜索
     * @param keywords
     * @return
     */
    List<Long> findListBykeywords(Map<String,Object> keywords);

    List<InfoActivityMsgDto> findListBykeywords2(Map<String,Object> keywords);

    /** 活动类型或者活动id查询活动
    *
    * @CopyRright  (c) 2018-微财科技有限公司
    * @author sunzhongshu
    * @created 2018/6/19 11:02
    * @modifier sunzhongshu
    */
    List<Long> findListByKeywordsNew(Map<String,Object> keywords);
}