package com.bxm.adsmanager.dal.mapper.adkeeper;

import java.util.List;
import java.util.Map;

import com.bxm.adsmanager.model.dto.AdAssetsTicketAuditDTO;
import com.bxm.adsmanager.model.vo.AdAssetsVo;
import com.bxm.adsmanager.model.vo.AssetsPopupVo;
import org.apache.ibatis.annotations.Param;

import com.bxm.adsmanager.model.dao.adkeeper.AdAssets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * <h3></h3>
 * @author hcmony
 * @since V1.0.0, 2017/12/14 19:11
 */
@Component
public interface AdAssetsMapper {

    int insert(AdAssets record);

    int insertDirectAsset(AdAssets record);

    int insertSelective(AdAssets record);

    AdAssets selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(AdAssets record);


    int updateDirectAssetByPrimaryKey(AdAssets record);

    /**
     * 根据id集合删除
     * @param longList
     * @return
     */
    int deleteByIds(@Param("longList") List<Long> longList);

//逻辑删除直投广告素材根据id
    int  deleteDirectAssetById(Long id);

    /**
     * @description 查找所有的广告素材
     * @author hcmony
     * @time 2017/12/8
     * @CopyRight 杭州微财网络科技有限公司
     * @return java.lang.Object
     */
    List<AdAssets> findAll(@Param("longList") List<Long> longList);


    /**
     * 根据广告券Id查找所有关联的广告券素材信息
     * @param ticketId  广告券Id
     * @return
     */
    List<AdAssets> findAllByTicketId(@Param("ticketId") Long ticketId);

    /**
     * 根据广告素材id找查广告券id
     * @param id
     * @return
     */
    Long findAdTicketById(@Param("id") Long id);
    
    /**
     * 根据参数素材信息
     * @param map  广告券Id
     * @return
     */
    List<AdAssets> findAllAssetsListByParams( Map<String,Object> map);
    //查询直投素材信息
    List<AdAssets> findDirectAssetsListByParams( Map<String,Object> map);

    /**
     * @description 根据条件获取数量
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param map
     * @return void
     */
    Integer getTotalCount(Map<String, Object> map);

    List<AdAssets> findAllAssetsByIdAndStatus(Map<String, Object> map);

    /**
     * 根据Id查找直投素材
     * @param id
     * @return
     */
    AdAssets findDirectAssetById(Long id );

    /**
     * 根据ids查出素材名称和图片 逗号分隔
     * @param ticketId
     * @return
     */
    List<AdAssetsTicketAuditDTO> findAssetsNameImgByTickets(@Param("ticketId") List<Long> ticketId);

    List<AdAssetsVo>  getAdAssetsVoByKeywords(@Param("keywords") String keywords ,
                                              @Param("ticketId")List<Long> ticketIds,
                                              @Param("assetsStatus")String assetsStatus);

    int  updateAuditStatusById(@Param("id") Long id ,
                    @Param("auditStatus") Short auditStatus ,
                    @Param("refuseReason") String refuseReason );

    List<AssetsPopupVo> getAssetsPopupList(@Param("popupKeyWord") String popupKeyWord,@Param("status") Integer status);


    /**
     * 根据广告券Id查找关联的素材个数
     * @param ticketId  广告券Id
     * @return
     */
    int countAssetsByTicketId(@Param("ticketId") Long ticketId);
}