package com.bxm.adsmanager.dal.mapper.adkeeper;

import java.util.List;

import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsStatistics;
import com.bxm.adsmanager.model.dto.AdAssetsStatisticsDto;
import com.bxm.adsmanager.model.vo.AdAssetsStatisticsVo;

public interface AdAssetsStatisticsMapper {
    
    int deleteByPrimaryKey(Long id);
    
    int deleteAll();

    int insertSelective(AdAssetsStatistics record);

    AdAssetsStatistics selectByPrimaryKey(Long id);
    
    /**
    * @Title: statAdAssetsLowClickRateCount  
    * @Description: 统计当前低于行业参考点击率的素材记录数
     */
    long statAdAssetsLowClickRateCount(AdAssetsStatisticsDto record);
    
    List<AdAssetsStatistics> selectTmpAssetsData();
    
    void insertBatch(List<AdAssetsStatistics> list);
    
    /**
    * @Title: selectAssetsLowClickRate  
    * @Description: 统计当前低于行业参考点击率的素材的ID
    * @return List<Long> 
     */
    List<Long> selectAssetsLowClickRate(AdAssetsStatisticsDto record) throws Exception;
    
    /**
    * @Title: selectAdTicketLowClickRate  
    * @Description: 统计当前低于行业参考点击率的的券ID
    * @return List<Long> 
     */
    List<Long> selectAdTicketLowClickRate(AdAssetsStatisticsDto record) throws Exception;
    
    /**
     * @Title: statAdAssetsListByParam  
     * @Description: 统计某个时间近24小时的素材
     * @return List<AdAssetsStatisticsVo> 
      */
    List<AdAssetsStatisticsVo> selectAdAssetslowClickRateList(AdAssetsStatisticsDto record) throws Exception;
    
    /**
     * @Title: statAdAssetsListByParam  
     * @Description: d导出某个时间近24小时的素材
     * @return List<AdAssetsStatisticsVo> 
      */
    List<AdAssetsStatisticsVo> exportAdAssetslowClickRateList(AdAssetsStatisticsDto record) throws Exception;
    

}