package com.bxm.adsmanager.dal.mapper.adkeeper;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.bxm.adsmanager.model.dao.adarpu.AdDomainArpu;
import com.bxm.adsmanager.model.dto.adarpu.AdDoMainArpuDto;

/**
 * @ClassName AdDomainArpuMapper
 * @Description arpu mapper服务接口
 * @Author xw
 * @Date 2018/4/17 17:16
 * @Version 1.0
 * @Modifier xw
 * @Modify Date 2018/4/17 17:16
 **/
public interface AdDomainArpuMapper{
    /**
     * @description 查询arpu默认值
     * @author xw
     * @date 2018/4/16 15:41 
     * @param domainCode 所属行业编码
    * @param settleType  结算方式：1- CPC、2- CPA、4- CPM
     * @return java.lang.String
     */  
    String selectArpuValue(@Param("domainCode") String domainCode, @Param("settleType") Short settleType);

    /**
     * @description 删除
     * @author xw
     * @date 2018/4/17 17:18
     * @param id
     * @return int
     */
    int deleteByPrimaryKey(@Param("id")Long id);

    /**
     * @description 全量新增
     * @author xw
     * @date 2018/4/17 17:18
     * @param adDomainArpu
     * @return java.lang.Long
     */
    int insert(@Param("adDomainArpu") AdDomainArpu adDomainArpu);

    /**
     * @description 根据主键查询
     * @author xw
     * @date 2018/4/17 17:19
     * @param id
     * @return com.bxm.adsmanager.model.dao.adarpu.AdDomainArpu
     */
    AdDomainArpu selectByPrimaryKey(@Param("id") Long id);

    /**
     * @description 更新
     * @author xw
     * @date 2018/4/17 17:19
     * @param adDomainArpu
     * @return int
     */
    int updateByPrimaryKey(@Param("adDomainArpu") AdDomainArpu adDomainArpu);

    /**
     * @description 根据条件查询所有
     * @author xw
     * @date 2018/4/17 17:22
     * @param adDoMainArpuDto
     * @return java.util.List<com.bxm.adsmanager.model.dao.adarpu.AdDomainArpu>
     */
    List<AdDomainArpu> findArpuPage(@Param("search") AdDoMainArpuDto adDoMainArpuDto);

    /**
     * @description 查询数据的总量
     * @author xw
     * @date 2018/4/17 19:24 
     * @param adDoMainArpuDto
     * @return int  
     */  
    int getTotalCount(@Param("search") AdDoMainArpuDto adDoMainArpuDto);
}
