package com.bxm.adsmanager.dal.mapper.adkeeper;

import com.bxm.adsmanager.model.dao.AdTicketPopup.ProvideAppDto;
import com.bxm.adsmanager.model.dao.adkeeper.AdPosition;
import com.bxm.adsmanager.model.dao.adprofit.InfoActivityAppBusiness;
import com.bxm.adsmanager.model.dto.AdPositionSearchDto;
import com.bxm.adsmanager.model.vo.AdpositionVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <h3></h3>
 * @author hcmony
 * @since V1.0.0, 2017/12/14 19:11
 */
public interface AdPositionMapper {

    int deleteByPrimaryKey(Long id);

    int insert(AdPosition record);

    int insertSelective(AdPosition record);

    AdPosition selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(AdPosition record);

    int updateByPrimaryKey(AdPosition record);


    /**
     * 根据条件查询总数   ，注意此方法查询的表是 info_activity_appbusiness
     * @param search
     * @return
     */
    @Deprecated
    public Integer totalcount(@Param("search") AdPositionSearchDto search);

    /**
     * 根据条件查询所有 ，注意此方法查询的表是 info_activity_appbusiness
     * @param search
     * @return
     */
    @Deprecated
    public List<AdpositionVo> findAll(@Param("search") AdPositionSearchDto search);

    /**
     * 根据appkey+business 集合查询所有 ，注意此方法查询的表是 info_activity_appbusiness
     * @param list
     * @return
     */
    @Deprecated
    public List<AdpositionVo> findAllByAppkey(@Param("list")List<String> list,
                                              @Param("search") AdPositionSearchDto search);

    /**
     * 查询排除list集合中的所有广告位，注意此方法查询的表是 info_activity_appbusiness
     * @param list
     * @return
     */
    @Deprecated
    public List<AdpositionVo> findAllExcludeAppkey(@Param("list")List<AdpositionVo> list,
                                                   @Param("search") AdPositionSearchDto search);

    /**
     * 根据条件查询所有 ，注意此方法查询的表是 info_activity_appbusiness
     * @param appName
     * @return
     */
    @Deprecated
    List<ProvideAppDto> findAllByAppName(@Param("appName") String appName);

    /**
     * 根据条件查询所有 ，注意此方法查询的表是 info_activity_appbusiness
     * @param list
     * @return
     */
    @Deprecated
    List<ProvideAppDto> findAllByPositionId(List<String> list);

    int findAppBusinessIsExist(@Param("appKey") String appKey,@Param("business") String business);

    int add(InfoActivityAppBusiness infoActivityAppBusiness);

}