package com.bxm.adsmanager.dal.mapper.adkeeper;

import java.util.List;

import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import com.bxm.adsmanager.model.dao.adkeeper.AdRules;
import com.bxm.adsmanager.model.dao.media.Rules;

/**
 * <h3></h3>
 *
 * @author hcmony
 * @since V1.0.0, 2017/12/14 19:11
 */
@Repository
public interface AdRulesMapper {

    int deleteByPrimaryKey(Long id);

    int insert(AdRules record);

    int insertSelective(AdRules record);

    AdRules selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(AdRules record);

    int updateByPrimaryKeyWithBLOBs(AdRules record);

    int updateByPrimaryKey(AdRules record);

    /**
     * 批量增加
     *
     * @param objects  值集合
     * @param ticketId 券id
     * @param target   目标
     * @param ruleType 规则类型
     * @return
     */
    Integer addBatch(@Param("objects") List<String> objects, @Param("ticketId") Long ticketId,
                     @Param("target") Integer target, @Param("ruleType") Integer ruleType);

    /**
     * 根据广告券id删除关联信息
     *
     * @param ticketId
     * @return
     */
    Integer deleteByTicketId(Long ticketId);

    /**
     * 根据广告券id查询关联信息
     *
     * @param ruleTarget   目标类型
     * @param ruleTypeEnum 规则类型
     * @param ticketId     券id
     * @return
     */
    String findByTicketId(@Param("target") Integer ruleTarget,
                          @Param("ruleType") Integer ruleTypeEnum,
                          @Param("targetId") Long ticketId);

    /**
     * 根据目标 ID 补充查询过滤规则
     *
     * @param ruleTarget
     * @param ruleTypeEnum
     * @param targetIdSupplement
     * @return java.lang.String
     * @author 阿导
     * @time 2018/4/9
     * @CopyRight 杭州微财科技有限公司
     */
    String findByTargetIdSupplement(@Param("target") Integer ruleTarget,
                                    @Param("ruleType") Integer ruleTypeEnum,
                                    @Param("targetIdSupplement") String targetIdSupplement);

    /**
     * 根据目标 ID 补充集合查询过滤规则
     *
     * @param ruleTarget
     * @param ruleTypeEnum
     * @param targetIdSupplements
     * @return java.util.HashMap<java.lang.String   ,   java.lang.String>
     * @author 阿导
     * @time 2018/4/9
     * @CopyRight 杭州微财科技有限公司
     */
    List<Rules> findByTargetIdSupplements(@Param("target") Integer ruleTarget,
                                          @Param("ruleType") Integer ruleTypeEnum,
                                          @Param("targetIdSupplements") List<String> targetIdSupplements);
    /**
     * 批量更新
     *
     * @author 阿导
     * @time 2018/4/9
     * @CopyRight 杭州微财科技有限公司
     * @param ruleTarget
     * @param ruleTypeEnum
     * @param rules
     * @return void
     */
    void updateByTargetIdSupplements(@Param("target") Integer ruleTarget,
                                     @Param("ruleType") Integer ruleTypeEnum,
                                     @Param("rules") List<Rules> rules);
    /**
     * 批量更新媒体标签地域时间段黑名单
     *
     * @author 阿导
     * @time 2018/4/9
     * @CopyRight 杭州微财科技有限公司
     * @param ruleTarget
     * @param ruleTypeEnum
     * @param rules
     * @return void
     */
    void batchInsertMediaTag(@Param("target") Integer ruleTarget,
                       @Param("ruleType") Integer ruleTypeEnum,
                       @Param("rules") List<Rules> rules);

    void deleteOldMediaTag();


    /**
     * 根据查找所哟过滤规则，同步数据的时候用
     *
     * @return java.lang.String
     * @author 阿导
     * @time 2018/4/9
     * @CopyRight 杭州微财科技有限公司
     */
    List<AdRules> findAllByTargetIdSupplement();

    void deleteByAdTicketAndType(@Param("ruleType") Integer ruleType,
                                 @Param("ticketId") Long ticketId);
    
    
    /**
     * 批量更新到备份表
     *
     * @author 拉拉
     * @time 2018/4/9
     * @CopyRight 杭州微财科技有限公司
     * @param ruleTarget
     * @param ruleTypeEnum
     * @param rules
     * @return void
     */
    void updateRuleBakByTargetIdSupplements(@Param("target") Integer ruleTarget,
                                     @Param("ruleType") Integer ruleTypeEnum,
                                     @Param("rules") List<Rules> rules);
    
 
    List<String> findTicketIdByParams(List<String> list);
 
    List<AdRules> findAllBakByTargetIdSupplement();
    
    List<String> findNewTicketIdByParams(List<String> list);

    /**
     * 根据类型查询关联信息
     *
     * @author zhengwangeng
     * @time 2019/8/15
     * @param ruleTarget   目标类型
     * @param ruleTypeEnum 规则类型
     * @return
     */
    List<String> findByTargetAndRuleType(@Param("target") Integer ruleTarget, @Param("ruleType") Integer ruleTypeEnum);

    /**
     * 查询特定广告券的 广告位定向 配置信息
     *
     * @author zhengwangeng
     * @time 2019/11/5
     * @param ruleTarget   目标类型
     * @param ruleTypeEnum 规则类型
     * @param ticketIds 广告券ID
     * @return
     */
    List<AdRules> findByTargetAndRuleTypeAndTargetIds(@Param("target") Integer ruleTarget,
                                                      @Param("ruleType") Integer ruleTypeEnum,
                                                      @Param("ticketIds") List<Long> ticketIds);

    /**
     * <p>批量新增</p>
     * @author zhengwangeng
     * @time 2019/11/6
     * @param recordList
     * @return
     */
    int insertBatch(List<AdRules> recordList);

    /**
     * <p>批量更新</p>
     * @author zhengwangeng
     * @time 2019/11/6
     * @param recordList
     * @return
     */
    int updateBatch(List<AdRules> recordList);


    AdRules findAdRulesByTicketId(@Param("target") Integer ruleTarget,
                          @Param("ruleType") Integer ruleTypeEnum,
                          @Param("targetId") Long ticketId);

    int deleteByIds(@Param("ids") List<Long> ids );

    List<Long> findAllMeituanTicket(String position);



    /**
     * 删除广告位指定的类型的配置信息
     * @param ruleTarget
     * @param ruleTypeEnum
     * @param targetIdSupplement
     * @return
     */
    void deleteByTargetIdSupplementType(@Param("target") Integer ruleTarget,
                                         @Param("ruleType") Integer ruleTypeEnum,
                                         @Param("targetIdSupplement") String targetIdSupplement);
}
