package com.bxm.adsmanager.dal.mapper.adkeeper;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.bxm.adsmanager.model.dao.adkeeper.AdTicketAssetsRef;

/**
 * <h3></h3>
 * @author hcmony
 * @since V1.0.0, 2017/12/14 19:11
 */
public interface AdTicketAssetsRefMapper {

    int deleteByPrimaryKey(Long id);

    int insert(AdTicketAssetsRef record);

    int insertSelective(AdTicketAssetsRef record);

    AdTicketAssetsRef selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(AdTicketAssetsRef record);

    int updateByPrimaryKey(AdTicketAssetsRef record);

    /**
     * 批量增加
     * @param assetsids 值
     * @param ticketId 广告券id
     * @return
     */
    Integer addBatch(@Param("assetsids") List<Long> assetsids, @Param("ticketId")Long ticketId);

    /**
     * 根据广告券id删除关联信息
     * @param ticketId
     * @return
     */
    Integer deleteByTicketId (Long ticketId);
    
    Integer deleteByAssetsIds (@Param("longList") List<Long> longList);

    /**
     * 根据广告券id查询关联信息
     * @param ticketId
     * @return
     */
    List<AdTicketAssetsRef> findByTicketId(@Param("ticketId")Long ticketId);
}