package com.bxm.adsmanager.dal.mapper.adkeeper;

import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketUrlTest;
import com.bxm.adsmanager.model.dto.*;
import com.bxm.adsmanager.model.dto.mobile.TicketQueryConditionDTO;
import com.bxm.adsmanager.model.dto.common.CommonSearchDto;
import com.bxm.adsmanager.model.vo.AdAbnormalTicketConsumeVo;
import com.bxm.adsmanager.model.vo.AdTicketAllVo;
import com.bxm.adsmanager.model.vo.AdTicketAppEntranceVo;
import com.bxm.adsmanager.model.vo.AdTicketValueVo;
import com.bxm.adsmanager.model.vo.adticketgroup.TicketVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <h3></h3>
 * @author hcmony
 * @since V1.0.0, 2017/12/14 19:11
 */
public interface AdTicketMapper {

    int deleteByPrimaryKey(Long id);

    Long insert(AdTicket record);

    int insertSelective(AdTicket record);

    AdTicket selectByPrimaryKey(Long id);

    int updateByPrimaryKey(AdTicket record);


    /**
     * 无法修改cpc
     * @param record
     * @return
     */
    int updateByPrimaryKeySelective(AdTicket record);

    /**
     * 根据条件查询总数
     * @param condition
     * @return
     */
    Integer totalcount(@Param("search") AdTicketSearchDto condition);

    /**
     * 根据条件查询所有
     * @param condition
     * @return
     */
    List<AdTicket> findAll(@Param("search") AdTicketSearchDto condition);

    /**
     * 根据条件查询所有
     * @return
     */
    List<AdTicket> findAllByIds(List<Long> list);


    /**
     * 只为同步 老平台 数据 准备
     * @param record
     * @return
     */
    int updateByTempOther(AdTicket record);


    /**
     * 根据条件查询所有
     * @param list
     * @return
     */
    List<AdTicket> findByids( List<Long> list);

    /**
     * 更新广告组ID和权益ID、广告活动标签
     *
     * @param id
     * @param groupId
     * @param rightsId
     */
    void updateGroupIdAndRightsId(@Param("id") Long id,
                                  @Param("groupId") Long groupId,
                                  @Param("rightsId") Long rightsId,
                                  @Param("ticketActivityMatchTag") Integer ticketActivityMatchTag);

    /**
     * 根据条件查询所有
     * @return
     */
    List<AdTicket> findAllTicket();

    /**
     * Description: 根据券名称模糊查询出 券ID集合
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/7/16 16:52
     */
    List<Long> findIdsByName(@Param("ticketName") String ticketName);

    /**
     * Description: 移动端-- 查询广告券列表
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/1 9:51
     */
    List<AdTicket> findTicketsInMobile(TicketQueryConditionDTO conditionDTO);

    /**
     * Description: 根据广告主ID集合 查询启用中的（status -> {1, 2}）所有券
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/3 15:15
     */
    List<AdTicket> findTicketsByAdvertiserIds(@Param("advertiserIds") List<Long> advertiserIds);

    /**
     * 查询可用广告券数量
     * @param excludeTicketIds
     * @return
     */
    int findAvalibaleTicketCount(@Param("positionId") String positionId);

    /**
     * 查询可用广告券信息
     * @param dto 查询参数
     * @return
     */
    List<AdTicket> findAvalibaleTicketList(@Param("search") CommonSearchDto dto);


    List<AdTicketUrlTest> findUrlTestList(@Param("search") AdTicketSearchDto condition);

    Integer urlTestCount(@Param("search") AdTicketSearchDto condition);

    //查询直投券X尺寸信息
    List<AdTicket>  findDirectTicketsByParams(@Param("search")DirectTicketSearch directTicketSearch);
    //查询是否存在直投券X尺寸的基本信息
    Long findLastDirectTicket(@Param("ticketId")Long ticketId,@Param("positionSize")String positionSize);
    //插入直投券X尺寸信息
    void  insertDirectTicket(@Param("ticketId")Long ticketId,@Param("positionSize")String positionSize,@Param("assetsId")Long assetsId);

    /**
     * Description: 根据券ID 和 AE查询券
     * JDK version used:<JDK1.8>
     * Create Date：2018/10/25 10:25

     * @param id 券ID
     * @param ae AE
     * @return com.bxm.adsmanager.model.dao.adkeeper.AdTicket
     * @author hxpeng
     */
    AdTicket findOneByIdAndAe(@Param("id") Long id, @Param("ae") String ae);

    List<AdTicket> findTicketByAe(@Param("ae") String ae);

    List<AdTicket> findTicketsByAdvertisers(@Param("advertiserIds") List<Long> advertiserIds);

    List<Long> findAdtickets(@Param("id") Long id, @Param("list") List<Short> list);


    /**
     * 根据落地页URL查询，关联的广告券
     * @param url
     * @return
     */
    List<Long> findAdticketsByUrl(@Param("url") String url);

    List<String> findPositionBlackIds(@Param("positionId") String positionId);

    /**
     * 更新流量包配置ID
     *
     * @param id
     * @param flowPackageOfferConfId
     */
    void updateFlowPackageOfferConfId(@Param("id") Long id, @Param("flowPackageOfferConfId") Long flowPackageOfferConfId);

    /**
     * 根据券id获取已停止的广告券信息
     * @param keyword
     * @author tangx
     * @DATE 2019/8/6 16:12
     */
    List<TicketVo> getStoppedTicket(@Param("keyword") String keyword);


    /**
     * 根据广告主id查出所有的券
     * @param advertiserIds
     * @return
     */
    List<AdTicket> findAllTicketsByAdvertiserIds(@Param("advertiserIds") List<Long> advertiserIds);

    void updateDateTimeById(@Param("id") Long id);

    List<AdTicketAllVo> getAvailableTicket(AvilableTicketSearchDto dto);

    List<AdTicketAppEntranceVo> getAdTicketAppEntrance(@Param("keywords") String keywords,
                                                       @Param("types") List<String> types,
                                                       @Param("status") Short status,
                                                       @Param("ids") List<String> ids,
                                                      /* @Param("groupIds") List<String> groupIds,*/
                                                       @Param("pauseReason") Integer pauseReason);


    //void updateMutexIdByticketIds(@Param("mutexId") Integer mutexId,@Param("ids") List<String> ids);
    List<AdAbnormalTicketConsumeVo> getAbnormalTicketConsume(AdAbnormalTicketConsumeSearchDTO search);


    List<AdTicketValueVo> findValusByIds(List<String> list);

    List<Long> selectTicketIdsByOpenStatus();
}
