package com.bxm.adsmanager.dal.mapper.adkeeper;

import com.bxm.adsmanager.model.dao.adkeeper.AdTicketTagConf;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketTagConfDO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <h3></h3>
 * @author hcmony
 * @since V1.0.0, 2017/12/14 19:11
 */
public interface AdTicketTagConfMapper {

    int deleteByPrimaryKey(Long id);

    int insert(AdTicketTagConf record);

    int insertSelective(AdTicketTagConf record);

    AdTicketTagConf selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(AdTicketTagConf record);

    int updateByPrimaryKey(AdTicketTagConf record);

    /**
     * 批量添加
     * @param tags
     * @param ticketId
     * @return
     */
    Integer addBatch(@Param("tags") List<String> tags, @Param("ticketId")Long ticketId);

    /**
     * 根据广告券id删除关联信息
     * @param ticketId
     * @return
     */
    Integer  deleteByTicketId (Long ticketId);

    /**
     * 根据广告券id查找所有关联信息
     * @param ticketId
     * @return
     */
    List<AdTicketTagConf> findByTicketId(Long ticketId);

    /**
     * Description: 根据标签code集合 查询 券ID集合
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/7/24 9:10
     */
    List<Long> findTicketIds(@Param("code") Integer code);

    /**
     * Description: 根据券ID集合 查询所属一级类目的名称
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/7/24 15:04
     */
    List<AdTicketTagConfDO> findTicketBelongCodeName(@Param("ticketIds") List<Long> ticketIds, @Param("tagType") Integer tagType);

    List<Long> findTicketIdsByCode(@Param("code") String code);

    List<Long> findTicketIdsByCodeWarn(@Param("code") String code);

    /**根据券id查找券的分类标签code*/
    String findTicketTag(@Param("ticketId") Long ticketId);

    /**
     * 根据券id查找券的分类标签code
     * @param ticketId
     * @return
     */
    List<Integer> findTicketAttributeTag(@Param("ticketId") Long ticketId);

    List<Long> findTicketIdByTagCode(Integer tagCode);
}