package com.bxm.adsmanager.dal.mapper.adkeeper.ext;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdAssetsAdxMapper;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsAdx;

public interface AdAssetsAdxMapperExt extends AdAssetsAdxMapper {

    /**
     * 查找所有的广告素材
     * @param assetsAdxIds
     * @return
     */
    List<AdAssetsAdx> findByIds(@Param("assetsAdxIds") List<Long> assetsAdxIds);

    /**
     * 批量插入数据
     * @param adAssetsAdxList
     * @return
     */
    int insertBatch(List<AdAssetsAdx> adAssetsAdxList);

    /**
     * <p>批量删除</p>
     */
    int deleteBatch(List<Long> idList);

    /**
     * 根据参数素材信息
     * @param map  广告券Id
     * @return
     */
    List<AdAssetsAdx> findAllAssetsListByParams(Map<String,Object> map);

    /**
     * 根据条件获取数量
     * @param map
     * @return
     */
    Integer getTotalCount(Map<String, Object> map);

    List<AdAssetsAdx> findAllByTicketId(@Param("id") Long id);
}