package com.bxm.adsmanager.dal.mapper.adkeeper.ext;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdAssetsCouponsMapper;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsCoupons;

public interface AdAssetsCouponsMapperExt extends AdAssetsCouponsMapper {

    /**
     * 批量更新这些素材归属于ticket
     * @param ticketId
     * @param assetsCouponsIds
     */
    void updateTicketIdByAssetsCouponsIds(@Param("ticketId") Long ticketId,
                                          @Param("assetsCouponsIds") List<Long> assetsCouponsIds);

    /**
     * 查找所有的广告素材
     * @param assetsCouponsIds
     * @return
     */
    List<AdAssetsCoupons> findByIds(@Param("assetsCouponsIds") List<Long> assetsCouponsIds);

    /**
     * 批量插入数据
     * @param adAssetsCouponsList
     * @return
     */
    int insertBatch(List<AdAssetsCoupons> adAssetsCouponsList);
}