package com.bxm.adsmanager.dal.mapper.adkeeper.ext;

import java.util.List;
import java.util.Map;

import com.bxm.adsmanager.model.vo.AdAssetsInspireVideoVo;
import com.bxm.adsmanager.model.vo.AdAssetsVo;
import org.apache.ibatis.annotations.Param;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdAssetsInspireVideoMapper;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsInspireVideo;
import org.springframework.stereotype.Component;

@Component
public interface AdAssetsInspireVideoMapperExt extends AdAssetsInspireVideoMapper {

    /**
     * 查找所有的广告素材
     * @param assetsInspireVideoIds
     * @return
     */
    List<AdAssetsInspireVideo> findByIds(@Param("assetsInspireVideoIds") List<Long> assetsInspireVideoIds);

    /**
     * 批量插入数据
     * @param adAssetsInspireVideoList
     * @return
     */
    int insertBatch(List<AdAssetsInspireVideo> adAssetsInspireVideoList);

    /**
     * 根据参数素材信息
     * @param map  广告券Id
     * @return
     */
    List<AdAssetsInspireVideo> findAllAssetsListByParams(Map<String, Object> map);

    /**
     * 根据条件获取数量
     * @param map
     * @return
     */
    Integer getTotalCount(Map<String, Object> map);

    /**
     * 查询ticketId下的所有素材
     * @param ticketId
     * @return
     */
    List<AdAssetsInspireVideo> findAllByTicketId(@Param("ticketId") Long ticketId);

    /**
     * 查询多个ticketId下的所有素材
     * @param ticketId
     * @return
     */
    List<AdAssetsInspireVideoVo> findAllByTicketIds(@Param("ticketIds") List<Long> ticketId);

    /**
     * 根据素材id找查广告券id
     * @param id
     * @return
     */
    Integer findTicketIdByInspireAssetsId(@Param("id") Long id);

    int updateAuditStatusById(@Param("id") Long id,@Param("auditStatus") Short auditStatus, @Param("refuseReason") String refuseReason);

    List<AdAssetsInspireVideoVo> getAdAssetsVoByKeywords(@Param("keywords") String keywords ,
                                                         @Param("ticketId")List<Long> ticketIds,
                                                         @Param("assetsStatus")String assetsStatus);
}