package com.bxm.adsmanager.dal.mapper.adkeeper.ext;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdAssetsTemplateAssetsMapper;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplateAssets;
import com.bxm.adsmanager.model.dto.AdAssetsTemplateAssetsAdxAuditStatusDTO;
import com.bxm.adsmanager.model.dto.AdAssetsTemplateAssetsTicketAssetsNumDTO;
import com.bxm.adsmanager.model.vo.AdAssetsTemplateAssetsAuditVO;

@Component
public interface AdAssetsTemplateAssetsMapperExt extends AdAssetsTemplateAssetsMapper {

    /**
     * 查找所有的广告素材
     * @param assetsTemplateAssetsIds
     * @return
     */
    List<AdAssetsTemplateAssets> findByIds(@Param("assetsTemplateAssetsIds") List<Long> assetsTemplateAssetsIds);

    /**
     * 根据参数素材信息
     * @param map  广告券Id
     * @return
     */
    List<AdAssetsTemplateAssets> findAllAssetsListByParams(Map<String, Object> map);

    /**
     * 根据条件获取数量
     * @param map
     * @return
     */
    Integer getTotalCount(Map<String, Object> map);

    /**
     * 查询ticketId下的所有素材
     * @param ticketId
     * @return
     */
    List<AdAssetsTemplateAssets> findAllByTicketId(@Param("ticketId") Long ticketId);

    /**
     * 查询多个ticketId下的所有素材
     * @param ticketIds
     * @return
     */
    List<AdAssetsTemplateAssetsAuditVO> findAllByTicketIds(@Param("ticketIds") List<Long> ticketIds);

    /**
     * 根据素材id找查广告券id
     * @param id
     * @return
     */
    Integer findTicketIdById(@Param("id") Long id);

    List<AdAssetsTemplateAssetsAuditVO> getAdAssetsTemplateAssetsVoByKeywords(@Param("keywords") String keywords,
                                                                         @Param("ticketId") List<Long> ticketIds,
                                                                         @Param("assetsStatus") String assetsStatus,
                                                                         @Param("checkStatus") String checkStatus);

    /**
     * 根据广告券Id查找关联的素材个数
     * @param ticketId  广告券Id
     * @return
     */
    int countAssetsByTicketId(@Param("ticketId") Long ticketId);

    /**
     * 批量修改状态
     * @param status
     * @param modifyUser
     * @param ids
     * @return
     */
    int batchUpdateStatus(@Param("status") Short status, @Param("modifyUser") String modifyUser, @Param("ids") List<Long> ids);

    /**
     * 查询多个ticketId下的素材的oppo审核状态
     * @param ticketIds
     * @return
     */
    List<AdAssetsTemplateAssetsAdxAuditStatusDTO> findAdxAuditStatus(@Param("ticketIds") List<Long> ticketIds);

    /**
     * 查询指定模板对应的素材数量
     * @param ticketId
     * @param assetsTemplateIds
     * @return
     */
    List<AdAssetsTemplateAssetsTicketAssetsNumDTO> findTemplateAssetsNum(@Param("ticketId") Long ticketId,
                                                                         @Param("assetsTemplateIds") List<String> assetsTemplateIds);

    /**
     * 根据广告券Id查找关联的素材个数
     * @param ticketId  广告券Id
     * @return
     */
    int countEnableAssetsByTicketId(@Param("ticketId") Long ticketId);
}