package com.bxm.adsmanager.dal.mapper.adkeeper.ext;

import java.util.List;

import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketAppExtendMapper;

/**
 * 券配置信息
 */
@Repository
public interface AdTicketAppExtendMapperExt extends AdTicketAppExtendMapper {

    /**
     * 查询ticketId
     * @param innerCrowdPackageId
     * @return
     */
    List<Long> findTicketIds(@Param("innerCrowdPackageId") Integer innerCrowdPackageId);

    /**
     * 批量修改指定券的一键复苏开关状态值
     * @param oneClickRecovery
     * @param ticketIds
     */
    void updateOneClickRecoveryByTicketIds(@Param("oneClickRecovery") Short oneClickRecovery,
                                          @Param("ticketIds") List<Long> ticketIds);

    /**
     * 批量修改指定券的一键复苏开关状态值(广告位配置里面的备份配置数据)
     * @param ticketIds
     */
    void updateOneClickRecoveryInBakByTicketIds(@Param("ticketIds") List<Long> ticketIds);

}
