package com.bxm.adsmanager.dal.mapper.adkeeper.ext;

import java.util.Date;
import java.util.List;
import java.util.Set;

import org.apache.ibatis.annotations.Param;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketCouponsCodeMapper;
import com.bxm.adsmanager.model.dto.AdTicketCouponsCodeStatusNumDto;

public interface AdTicketCouponsCodeMapperExt extends AdTicketCouponsCodeMapper {

    /**
     * 批量增加
     *
     * @param codes  码值集合
     * @param ticketId 券id
     * @param status   状态
     * @param createTime 创建时间
     * @param createUser 创建人
     * @return
     */
    Integer addBatch(@Param("codes")Set<String> codes, @Param("ticketId") Long ticketId,
                     @Param("status") Short status, @Param("createTime") Date createTime, @Param("createUser") String createUser);

    /**
     * 查询各状态的数量
     * @param ticketId
     * @return
     */
    List<AdTicketCouponsCodeStatusNumDto> findStatusNumByTicketId(@Param("ticketId") Long ticketId);
}