package com.bxm.adsmanager.dal.mapper.adkeeper.ext;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdAssetsAdxMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketGetuiTagRefMapper;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsAdx;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketGetuiTagRef;

public interface AdTicketGetuiTagRefMapperExt extends AdTicketGetuiTagRefMapper {

    /**
     * 批量插入数据
     * @param adTicketGetuiTagRefList
     * @return
     */
    int insertBatch(List<AdTicketGetuiTagRef> adTicketGetuiTagRefList);

    /**
     * 删除指定广告券的个推标签数据
     * @param ticketId
     */
    void deleteByTicketId(@Param("ticketId") Long ticketId);

    /**
     * 获取指定广告券的个推标签数据
     * @param ticketId
     */
    void findByTicketId(@Param("ticketId") Long ticketId);
}