package com.bxm.adsmanager.dal.mapper.adkeeper.ext;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdPositionMapper;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dto.*;
import com.bxm.adsmanager.model.vo.AdTicketAuditVo;
import com.bxm.adsmanager.model.vo.AdTicketVo;
import com.bxm.adsmanager.model.vo.AdTicketWeightVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * <h3></h3>
 * @author hcmony
 * @since V1.0.0, 2017/12/14 19:11
 */
@Repository
public interface AdTicketMapperExt extends AdPositionMapper{

    List<AdTicket> findTicketByAdvertiser(@Param("search") AdTicketSearchDto adTicketSearchDto);

    List<AdTicket> getTicketsByNameOrId(@Param("search") AdTicketSearchDto adTicketSearchDto);

    /**  
     * @Title: findTicketListByCondition  
     * @Description:  通过查询条件查询礼券列表
     * @author xavier  
     * @date 2018年3月20日
     */  
    List<AdTicket> findTicketListByCondition(@Param("search") AdTicketSearchDto adTicketSearchDto);

    List<AdTicketWeightVo> getTicketsByCondition(@Param("search") AdTicketSearchDto adTicketSearchDto);

    List<AdvertiserCheckDto> findStatusNum(@Param("advertiserIds")List<Integer> advertiserIds);

    List<AdTicketCheckDto> findCheckTicket(@Param("ids")List<Integer> ids,@Param("status")Integer status,@Param("keyWord")String keyWord);
    
    int updateStatus(Map<String,Object> map);
    
    List<AdTicketCheckDto> findWaitCheckTicket(@Param("ids")List<Integer> ids,@Param("status")Integer status,@Param("keyWord")String keyWord,
            @Param("createUser")String createUser,@Param("queryFlag")String queryFlag,@Param("ae")String ae);
    
    long findTicketByStatus(@Param("status") short status );


    /**
     * Description: 根据广告主 和 广告主券类型 查询 广告券
     * JDK version used:<JDK1.8>
     * Create Date：2018/12/11 16:34
     *
     * @param advertiserId 广告主ID
     * @param typeCode     广告券类型
     * @return java.util.List<com.bxm.adsmanager.model.dao.adkeeper.AdTicket>
     * @author hxpeng
     */
    List<AdTicket> findCpcTicketByAdvertiserAndType(@Param("advertiserId") Integer advertiserId, @Param("typeCode") Integer typeCode);


    /*
    * @description 查询存在的券ID
    * @param [list]
    * @return java.util.List<java.lang.Long>
    */
    List<Long> findExistTicketId(List<Long> list);


    /*订正数据使用*/
    List<AdTicketVo> findTicketIdsByAdvertiserId(List<Long> list);

    /**
     * 广告审核列表
     * @param advertiserDTO
     * @return
     */
    List<AdTicketAuditVo> getTicketAuditList(AdTicketAuditSearchDTO advertiserDTO);

    /**
     * 获取券对应类型
     * @param ticketIds
     * @return
     */
    List<TicketTypeNameDTO> getTypeNameByTickets(@Param("ticketIds") List<Long> ticketIds);
}
