package com.bxm.adsmanager.dal.mapper.adkeeper.ext;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketWeightManualConfMapper;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketWeightManualConf;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * <h3></h3>
 *
 * @author qinganquan
 * @since V1.0.0, 2017/12/14 19:11
 */
@Repository
public interface AdTicketWeightManualConfMapperExt extends AdTicketWeightManualConfMapper {

    List<AdTicketWeightManualConf> selectByTicketIds(@Param("ticketIds") List<Long> ticketIds);

    int updateInterventionFactor(Map<String, Object> map);


    /**
     * Description: 批量修改券的干预系数
     * JDK version used:<JDK1.8>
     * Create Date：2018/12/13 16:28
     *
     * @param ticketIds          券ID集合
     * @param interventionFactor 干预系数
     * @return int
     * @author hxpeng
     */
    int batchUpdateTicketWeight(@Param("ticketIds") List<Long> ticketIds,
                                @Param("interventionFactor") Double interventionFactor,
                                @Param("operationUserName") String operationUserName);


    /**
     * Description: 根据广告券权重表主键ID集合 批量判断 然后 修改 干预系数
     * JDK version used:<JDK1.8>
     * Create Date：2018/12/14 15:55
     *
     * @param ids             券ID集合
     * @param oldInterventionFactor 旧干预系数
     * @param newInterventionFactor 新干预系数
     * @return java.lang.Integer
     * @author hxpeng
     */
    Integer batchCompareAndUpdateInterventionFactorByIds(@Param("ids") List<Long> ids,
                                                         @Param("oldInterventionFactor") Double oldInterventionFactor,
                                                         @Param("newInterventionFactor") Double newInterventionFactor);
}