package com.bxm.adsmanager.dal.mapper.adprofit;
import com.bxm.adsmanager.model.dao.profit.ProfitMediaSettle;
import com.bxm.adsmanager.model.dto.adprofit.DeveloperProfitDto;
import com.bxm.adsmanager.model.vo.adprofit.DeveloperProfitVo;
import com.bxm.adsmanager.model.vo.adprofit.DeveloperSetletProfitVo;

import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * <p>开发者收益</p>
 *
 * @Description: 开发者收益相关接口数据查询类
 * @Author: JandMin
 * @Date: 2018/6/11
 */
@Repository
public interface DeveloperProfitMapper {
    /**
     * @description: 获取开发者总金额数据
     * @author: JandMin
     * @time: 2018/6/12 16:14
     * @param search
     * @return com.bxm.adsmanager.model.vo.adprofit.DeveloperProfitVo
     */
    Map<String,Object> getUnSettledProfit(@Param("search") DeveloperProfitDto search);
    /**
     * @description: 获取开发者结算金额和扣款金额汇总数据
     * @author: JandMin
     * @time: 2018/6/12 11:10
     * @param search
     * @return com.bxm.adsmanager.model.vo.adprofit.DeveloperProfitVo
     */
    DeveloperProfitVo getTotalProfitFromMediaSettle(@Param("search") DeveloperProfitDto search);
    /**
     * @description: 获取开发者收益信息列表 分页信息
     * @author: JandMin
     * @time: 2018/6/11 15:32
     * @param search
     * @return java.util.List<com.bxm.adsmanager.model.vo.adprofit.DeveloperProfitVo>
     */
    List<DeveloperProfitVo> findProfitListByPage(@Param("search") DeveloperProfitDto search);

    /**
     * @description: 获取不同得日期的总记录数
     * @author: JandMin
     * @time: 2018/6/11 17:21
     * @param search
     * @return int 总记录数
     */
    int getTotalCountOfDatetime(@Param("search") DeveloperProfitDto search);

    /**
     * @description: 获取开发者结算和扣款记录的分页数据列表
     * @author: JandMin
     * @time: 2018/6/13 18:04
     * @param search
     * @return java.util.List<com.bxm.adsmanager.model.vo.adprofit.DeveloperProfitVo>
     */
    List<DeveloperProfitVo> findProfitByDateByPage(@Param("search") DeveloperProfitDto search);

    /**
     * @description: 获取开发者未结算金额
     * @author: JandMin
     * @time: 2018/6/13 19:17
     * @param search
     * @return java.util.List<java.util.Map<java.lang.String,java.lang.Object>>
     */
    List<Map<String,Object>> findUnsettledProfits(@Param("search") DeveloperProfitDto search);

    /**
     * @description: 根据时间获取开发者可结算金额（不包含时间当天）
     * @author: JandMin
     * @time: 2018/6/14 11:55
     * @param search
     * @return java.util.List<com.bxm.adsmanager.model.vo.adprofit.DeveloperProfitVo>
     */
    List<DeveloperProfitVo> findInfoForSettle(@Param("search") DeveloperProfitDto search);

    /**
     * @description: 新增开发者结算记录
     * @author: JandMin
     * @time: 2018/6/14 20:10
     * @param params
     * @return int
     */
    int insertSettledInfo(Map<String, Object> params);

    /**
     * @description: 修改开发者收益记录表中为已结算
     * @author: JandMin
     * @time: 2018/6/14 20:43
     * @param params
     * @return int
     */
    int updateProfitInfo(Map<String, Object> params);

    /**
     * @description: 开发者收益数据推送异常时增加数据库异常信息
     * @author: JandMin
     * @time: 2018/6/20 11:23
     * @param params
     * @return void
     */
    void updateErrorMsg(Map<String, Object> params);
    
    /**
     * @description: 批量新增开发者结算记录
     * @author: 拉拉
     * @time: 2018/7/25 20:10
     * @param params
     * @return int
     */
    int batchinsertSettledInfo(List<ProfitMediaSettle> list);
    
    /**
     * @description: 获取开发者所有未结算列表
     * @author: 拉拉
     * @time: 2018/7/25 19:17
     * @param map
     * @return  
     */
    List<DeveloperSetletProfitVo> findDeveloperProfitVoByParam(Map<String,Object> map);
}
