package com.bxm.adsmanager.dal.mapper.adprofit.ext;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.bxm.adsmanager.dal.mapper.adprofit.AdProfitMediaMapper;
import com.bxm.adsmanager.model.dao.adprofit.AdProfitMedia;
import com.bxm.adsmanager.model.dto.AdMediaPositionProfitSearchDto;
import com.bxm.adsmanager.model.vo.adprofit.AdProfitMediaVo;
import org.springframework.stereotype.Repository;

/**  
* @Title: AdProfitMediaExt 
* @Description:  媒体收益信息拓展接口
* @author xavier  
* @date 2018年3月3日  
*/
@Repository
public interface AdProfitMediaMapperExt extends AdProfitMediaMapper{
	
	/**  
	 * @Title: getProfitMsgGroupPosition  
	 * @Description:  查询媒体收益信息，通过媒体分组
	 * @author xavier  
	 * @date 2018年3月3日
	 */  
	List<AdProfitMedia> getProfitMsgGroupMedia(String datetime);
	
	/**  
	 * @Title: getMediaProfitPage  
	 * @Description:  查询媒体收益分页信息
	 * @author xavier  
	 * @date 2018年3月7日
	 */  
	List<AdProfitMediaVo> getMediaProfitPage(@Param("search") AdMediaPositionProfitSearchDto
													 condition);

	/**  
	 * @Title: countMediaMsg  
	 * @Description:  查询list总量
	 * @author xavier  
	 * @date 2018年3月7日
	 */  
	Integer countMediaMsg(@Param("search") AdMediaPositionProfitSearchDto condition);


    /**
     * 获取媒体的实际收益
     *
     * @author 阿导
     * @time 2018/3/8
     * @CopyRight 杭州微财科技有限公司
     * @param datetime
     * @return java.util.List<com.bxm.adsmanager.model.dao.adprofit.AdProfitMediaVo>
     */
	List<AdProfitMedia> getProfitMsgGroupMediaOld(String datetime);

	/**
	 * @Title: getProfitMsgGroupPosition
	 * @Description: 通过时间查询没有录入收益的广告位收益信息
	 */
	List<AdProfitMedia> findProfitMediaByDatetime(String datetime);

	void updateProfitDeductByDatetime(String datetime);
	
	List<AdProfitMedia> findProfitMediaByParam(Map<String,Object> map);
	
	
}
