package com.bxm.adsmanager.dal.mapper.adprofit.ext;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.bxm.adsmanager.dal.mapper.adprofit.AdProfitPositionMapper;
import com.bxm.adsmanager.model.dao.adprofit.AdProfitPosition;
import com.bxm.adsmanager.model.dto.AdMediaPositionProfitSearchDto;
import com.bxm.adsmanager.model.dto.adprofit.OdpsAppBusinessAbStatDto;
import com.bxm.adsmanager.model.vo.adprofit.AdProfitPositionVo;
import org.springframework.stereotype.Repository;

/**  
* @Title: AdProfitPositionExt 
* @Description:  广告位收益信息拓展接口
* @author xavier  
* @date 2018年3月3日  
*/
@Repository
public interface AdProfitPositionMapperExt extends AdProfitPositionMapper{

	/**  
	 * @Title: getProfitMsgGroupPosition  
	 * @Description: 通过时间查询广告位收益信息，通过广告位分组 
	 * @author xavier  
	 * @date 2018年3月3日
	 */  
	List<AdProfitPosition> getProfitMsgGroupPosition(String datetime);
	
	/**  
	 * @Title: getMediaProfitPage  
	 * @Description:  查询媒体收益分页信息
	 * @author xavier  
	 * @date 2018年3月7日
	 */  
	List<AdProfitPositionVo> getPositionProfitPage(@Param("search") AdMediaPositionProfitSearchDto condition);

	/**  
	 * @Title: countMediaMsg  
	 * @Description:  查询list总量
	 * @author xavier  
	 * @date 2018年3月7日
	 */  
	Integer countPositionMsg(@Param("search") AdMediaPositionProfitSearchDto condition);

	/**
	 * 获取老表的推广位的收益
	 *
	 * @author 阿导
	 * @time 2018/3/8
	 * @CopyRight 杭州微财科技有限公司
	 * @param datetime 查询时间
	 * @return java.util.List<com.bxm.adsmanager.model.dao.adprofit.AdProfitPositionVo>
	 */
	List<AdProfitPosition> getProfitMsgGroupPositionOld(String datetime);


	/**
	 * 更新每个广告位的预估收益比率
	 * @param datetime
	 * @param appId
	 */
	void updateCashRateByDatetime(@Param("datetime") String datetime,
							  @Param("appId")String appId,
							  @Param("username") String username);

	/**
	 * 按照比率更新每个广告位的预估收益
	 * @param datetime
	 * @param appId
	 */
	void updateCashByDatetime(@Param("datetime") String datetime,
							  @Param("appId")String appId,
							  @Param("username") String username);

	/**
	 * @Title: getProfitMsgGroupPosition
	 * @Description: 通过时间查询没有录入收益的广告位收益信息
	 */
	List<AdProfitPosition> findProfitPositionByDatetime(@Param("datetime") String datetime,
														@Param("appId")String appId);
	
	/**
     * @Title: findProfitPositionByParam
     * @Description: 通过时间查询没有录入收益的广告位收益信息
     */
    List<AdProfitPosition> findProfitPositionByParam(Map<String,Object> map);

	/**
	 * 根据positionId和时间更新表的状态
	 * @param datetime
	 * @param username
	 * @param positionId
	 */
	void updateStatusByDatetime(@Param("datetime") String datetime,
						   @Param("username") String username,
						   @Param("positionId")String positionId);
	
	/**  
	 * @Title: findPositionCheatMsg  
	 * @Description:  根据时间查询 广告位作弊信息
	 * @author xavier  
	 * @date 2018年4月2日
	 */  
	List<OdpsAppBusinessAbStatDto> findPositionCheatMsg(@Param("datetime") String datetime);

	/**
	 * 当uv <100 时调用这个方法，更新广告位的扣量金额=广告位的预估收益
	 *
	 * @param positionIds
	 * @return void
	 * @throws
	 * @author kk.xie
	 * @date 2018/7/14 21:15
	 */
	void updatProfitDeduct(@Param("positionIds")List<String> positionIds);


	/**
	 * 更新广告位的预估收益
	 * @param map
	 */
	void updateProfit(Map map);

	/**
	 * 根据时间查找所有广告位消耗
	 * @param datetime
	 * @return
	 */
	List<AdProfitPosition> findPositionByDatetime(@Param("datetime") String datetime);
	
	/**
     * 根据时间查询广告位时间范围内总的实际收益
     * @param datetime
     * @return
     */
    List<Map<String,Object>> findPositionTotalActualProfitByTime(@Param("beginTime") String beginTime,
            @Param("endTime") String endTime);
    
    /**
     * 根据时间查询appKey集合
     * @param datetime
     * @return
     */
    List<String> findProfitAppIdListByDate(@Param("datetime") String datetime);


    /**
     * 根据时间查找所有广告位消耗2
     * @param datetime
     * @return
     */
    List<AdProfitPosition> findPositionByDatetimeV2(@Param("datetime") String datetime);

    Long getTotalActualProfitByAppKeyDatetime(@Param("appKey") String appKey, @Param("startDate") String startDate, @Param("endDate") String endDate);

    List<AdProfitPosition> getListByParams(@Param("appKeys") List<String> appKeys, @Param("startDate") String startDate, @Param("endDate") String endDate, @Param("position") String position);


}
