package com.bxm.adsmanager.dal.mapper.adprofit.ext;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import com.bxm.adsmanager.model.dao.adprofit.AdTicketIncome;
import org.apache.ibatis.annotations.Param;

import com.bxm.adsmanager.model.vo.AdTicketIncomeDetailVo;
import com.bxm.adsmanager.model.vo.AdTicketIncomeVo;

/**  
* @Title: AdTicketIncomeExt 
* @Description:  礼券收益接口实现
* @author xavier  
* @date 2018年3月5日  
*/  
public interface AdTicketIncomeMapperExt{

	/**  
	 * @Title: getAdTicketIncomeTotalMsg  
	 * @Description:  根据查询条件获取礼券收益总信息列表，根据时间分组
	 * @author xavier  
	 * @date 2018年3月5日
	 */  
	public List<AdTicketIncomeVo> getAdTicketIncomeTotalMsg(Map<String, Object> param);

	/**  
	 * @Title: getAdTicketIncomeTotalMsg  
	 * @Description:  根据查询条件获取礼券收益信息详情列表
	 * @author xavier  
	 * @date 2018年3月5日
	 */  
	public List<AdTicketIncomeDetailVo> getAdTicketIncomeDetailMsg(Map<String, Object> param);
	
	/**  
	 * @Title: updateCashByDatetimeAndTicket  
	 * @Description:  根据时间和礼券ID修改礼券消耗
	 * @author xavier  
	 * @date 2018年3月26日
	 */  
	public void updateCashByDatetimeAndTicket(Map<String, Object> msg);
	
	/**  
	 * @Title: getTicketIdByDatetime  
	 * @Description:  根据时间获取已经录入收益的礼券
	 * @author xavier  
	 * @date 2018年3月28日
	 */  
	public List<Long> getTicketIdByDatetime(String datetime);
	
	/**  
	 * @Title: findIncomeOfMaxDatetime  
	 * @Description:  查询除查询条件之外礼券最早有收益的信息
	 * @author xavier  
	 * @date 2018年4月3日
	 */  
	public AdTicketIncomeDetailVo findIncomeOfMaxDatetime(@Param("datetime") String datetime,
    		@Param("ticketId") Long ticketId);

	/**
	 * 查找当天的广告总消耗
	 * @param datetime
	 * @return
	 */
	public Long  fingToTalIncome(String datetime);
	
	public Map<String,BigDecimal> fingTotalCost(String datetime);


	public List<AdTicketIncomeDetailVo> fingAdTicketIncome(Map<String, Object> param);

	public List<AdTicketIncomeDetailVo> fingAdTicketIncomeByDatetime(String datetime);


    /**
     * Description: 查询一段时间内，已录入的相关券的消耗
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/3 11:12
     *
     * @param ticketIds 券ID集合
     * @param beginDate 开始时间
     * @param endDate   结束时间
     * @return java.util.List<com.bxm.adsmanager.model.dao.adprofit.AdTicketIncome>
     * @author hxpeng
     */
    List<AdTicketIncome> findAllByTicketIdsInTimeFrame(@Param("ticketIds") List<Long> ticketIds,
                                                       @Param("beginDate") String beginDate,
                                                       @Param("endDate") String endDate);

	
}
