package com.bxm.adsmanager.dal.mapper.adprofit.ext;

import java.util.List;
import java.util.Map;

import com.bxm.adsmanager.model.dao.adprofit.InfoActivityCertificateDaycash;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import com.bxm.adsmanager.model.vo.AdTicketIncomePositionVo;

@Repository
public interface AdTicketIncomePositionMapperExt {
    /**  
     * @Title: fingMsgGroupMedia  
     * @Description:  查询礼券消耗信息，媒体维度
     * @author xavier  
     * @date 2018年3月8日
     */  
    List<AdTicketIncomePositionVo> fingMsgGroupMedia(String datetime);

    /**  
     * @Title: fingMsgGroupPosition  
     * @Description:  查询礼券消耗信息，广告位维度
     * @author xavier  
     * @date 2018年3月8日
     */  
    List<AdTicketIncomePositionVo> fingMsgGroupPosition(String datetime);

    /**
     * 查询券收入按开发者分组
     *
     * @author 阿导
     * @time 2018/3/8
     * @CopyRight 杭州微财科技有限公司
     * @param datetime
     * @return java.util.List<com.bxm.adsmanager.model.vo.AdTicketIncomeVo>
     */
    List<AdTicketIncomePositionVo> findAdTicketIncomeGroupMediaOld(String datetime);

    /**
     * 查询券收入按推广位分组
     *
     * @author 阿导
     * @time 2018/3/8
     * @CopyRight 杭州微财科技有限公司
     * @param datetime
     * @return java.util.List<com.bxm.adsmanager.model.vo.AdTicketIncomeVo>
     */
    List<AdTicketIncomePositionVo> fingMsgGroupPositionOld(String datetime);


    List<AdTicketIncomePositionVo> findTicketIncomeOld(Map<String,Object> map);

    /**
     * 查找当天的广告消耗
     * @param datetime
     * @return
     */
    Long  fingToTalConsume(String datetime);

    /**
     * 同步收益到老表，为了给广告主看数据
     */
    void updateOldDayCash(@Param("datetime") String datetime,
                          @Param("list") List<InfoActivityCertificateDaycash> list);
    
    /**  
     * @Title: findTicketIncomeByPosition  
     * @Description:  通过时间查询子渠道收益信息
     * @author xavier  
     * @date 2018年4月3日
     */  
    List<AdTicketIncomePositionVo> findTicketIncomeByPosition(@Param("datetime") String datetime,
                          @Param("ticketId") Long ticketId);
    
    /**  
     * @Title: findTicketIncomeByPosition  
     * @Description:  通过时间查询老表子渠道收益信息
     * @author xavier  
     * @date 2018年4月3日
     */  
    List<AdTicketIncomePositionVo> findTicketIncomeByPositionOld(@Param("datetime") String datetime,
    		@Param("ticketId") Long ticketId);


    public List<AdTicketIncomePositionVo> findAllByType(@Param("datetime") String datetime,
                                                        @Param("product") String product);

    public List<AdTicketIncomePositionVo> findAllByAppId(@Param("datetime") String datetime,
                                                        @Param("appid") String appid);

}
