package com.bxm.adsmanager.dal.mapper.adticketgroup;

import com.bxm.adsmanager.model.dao.adticketgroup.TicketGroup;
import com.bxm.adsmanager.model.vo.adticketgroup.TicketGroupVo;
import com.bxm.adsmanager.model.vo.adticketgroup.TicketVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * 广告组数据访问层
 *
 * @author 阿导
 * @version 1.0
 * @fileName com.bxm.adsmanager.dal.mapper.adticketgroup.TicketGroupMapper.java
 * @CopyRright (c) 2018-杭州微财科技有限公司
 * @created 2018-03-22 17:49:00
 */
@Repository
public interface TicketGroupMapper {

    /**
     * 根据条件查询广告组
     *
     * @author 阿导
     * @time 2018/3/22
     * @CopyRight 杭州微财科技有限公司
     * @param map
     * @return java.util.List<com.bxm.adsmanager.model.dao.adticketgroup.TicketGroup>
     */
    List<TicketGroupVo> findTicketGroup(Map<String,Object> map);

    /**
     * 新增广告组
     *
     * @author 阿导
     * @time 2018/3/22
     * @CopyRight 杭州微财科技有限公司
     * @param ticketGroup
     * @return java.lang.Long
     */
    void insertTicketGroup(@Param("ticketGroup") TicketGroup ticketGroup);

    /**
     * 更新广告组
     *
     * @author 阿导
     * @time 2018/3/22
     * @CopyRight 杭州微财科技有限公司
     * @param ticketGroup
     * @return void
     */
    void updateTicketGroup(@Param("ticketGroup") TicketGroup ticketGroup);

    /**
     * 更新传入的信息广告组
     *
     * @author 阿导
     * @time 2018/3/22
     * @CopyRight 杭州微财科技有限公司
     * @param ticketGroup
     * @return void
     */
    void updateTicketGroupSelective(@Param("ticketGroup") TicketGroup ticketGroup);

    /**
     * 获取广告组下广告数目
     *
     * @author 阿导
     * @time 2018/3/23
     * @CopyRight 杭州微财科技有限公司
     * @param groupIds
     * @return java.util.List<com.bxm.adsmanager.model.vo.adticketgroup.TicketGroupVo>
     */
    List<TicketGroupVo> findTicketCount(@Param("groupIds")List<Long> groupIds);

    /**
     * 查询广告券
     *
     * @author 阿导
     * @time 2018/3/23
     * @CopyRight 杭州微财科技有限公司
     * @param map
     * @return java.util.List<com.bxm.adsmanager.model.vo.adticketgroup.TicketVo>
     */
    List<TicketVo> findTicket(Map<String,Object> map);

    /**
     * 处理广告组信息
     *
     * @author 阿导
     * @time 2018/3/23
     * @CopyRight 杭州微财科技有限公司
     * @param groupId
     * @param ticketIds
     * @return void
     */
    void dealTicketGroup(@Param("groupId") Long groupId,@Param("ticketIds") List<Long> ticketIds);
}
