package com.bxm.adsmanager.dal.mapper.adticketpopup;

import com.bxm.adsmanager.model.dao.AdTicketPopup.AdTicketPopup;
import com.bxm.adsmanager.model.dto.AdTicketPopupDto;
import com.bxm.adsmanager.model.vo.AdTicketPopupVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * <h3></h3>
 * @author hcmony
 * @since V1.0.0, 2017/12/14 19:11
 */
@Repository
public interface AdTicketPopupMapper {

    /**
     * @description 批量插入数据
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param list
     * @return void
     */
    void insert(List<AdTicketPopup> list);

    /**
     * @description 删除数据
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param positionId
     * @return void
     */
    void deleteByPositionId(@Param("positionId") String positionId) ;


    /**
     * @description 查找全部数据
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param
     * @return void
     */
    List<AdTicketPopupVo> findAll(Map<String, Object> paramsMap ) ;

    /**
     * @description 查找全部数据数量
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param
     * @return void
     */
    Integer totalcount(Map<String, Object> paramsMap);

    /**
     * @description 根据入口id查找弹窗券
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param
     * @return void
     */
    List<AdTicketPopup> findByPositionId(@Param("positionId") String positionId ) ;


}