package com.bxm.adsmanager.dal.mapper.advertiser.ext;

import com.bxm.adsmanager.dal.mapper.advertiser.TblAdQualifyMapper;
import com.bxm.adsmanager.integration.advertiser.model.Advertiser;
import com.bxm.adsmanager.model.dao.advertiser.TblAdQualify;
import com.bxm.adsmanager.model.dto.QualifyTypeStrDTO;
import com.bxm.adsmanager.model.dto.TblAdQualifyDto;

import com.bxm.adsmanager.model.vo.AdvertiserQualifyInfoVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Date;
import java.util.List;

/**
 * @author sunzhongshu
 * @fileName
 * @CopyRright (c) 2018-杭州微财科技有限公司
 * @created 2018/7/5 22:03
 */
@Component
public interface TblAdQualifyMapperExt extends TblAdQualifyMapper {

    /**
    * 根据广告主id查找他的所有资质
    * @CopyRright  (c) 2018-微财科技有限公司
    * @author sunzhongshu
    * @created 2018/7/5 22:42
    * @modifier sunzhongshu
    */

    List<TblAdQualify> findQualifyList(Integer advertiserId);

    /**
     * 获取所有资质信息
     * @return
     */
    List<TblAdQualify> qualifyList();

    /**
    *  根据id删除逻辑删除资质
    * @CopyRright  (c) 2018-微财科技有限公司
    * @author sunzhongshu
    * @created 2018/7/6 10:24
    * @modifier sunzhongshu
    */

    void deleteQualify(@Param("deleteList") List<String> deleteList, @Param("date") Date date);

    /**
    *  资质批量添加(AE添加)
    * @CopyRright  (c) 2018-微财科技有限公司
    * @author sunzhongshu
    * @created 2018/7/13 13:24
    * @modifier sunzhongshu
    */

    int insertTblAdQualifys(List<TblAdQualify> list);
    
    
    //下面是对广告主自己添加资质的操作
    
    /**
    * @Title: insertAdQualifyBatch  
    * @Description: 广告主添加的资质(广告主添加)
    * @param List<TblAdQualify> list
     */
    void insertAdQualifyBatch(List<TblAdQualify> list);
    
    /**
    * @Title: queryAdQualifyList  
    * @Description: 查询广告主添加的资质列表
    * @return List<TblAdQualify> 
     */
    List<TblAdQualify> queryAdQualifyList(TblAdQualifyDto param);
    
    /**
    * @Title: queryAdQualifyCount  
    * @Description: 查询广告主添加的资质总记录数
    * @param TblAdQualifyDto
    * @return long 
     */
    long queryAdQualifyCount(TblAdQualifyDto param);
    
    /**
    * @Title: updateAuditStatusByIds  
    * @Description: 批量审核通过广告主资质
    * @param List<Integer> list
    * @return void 
     */
    void updateAuditStatusByIds(List<Integer> list);
    
    
    /**
    * @Title: updateAuditStatusBatch  
    * @Description: 批量审核拒绝
    * @param List<TblAdQualify> list
    * @return void 
     */
    void updateAuditStatusBatch(List<TblAdQualify> list);

    /**
     * 查出该资质状态下的所有广告主id
     * @param qualifyStatus
     * @return
     */
    List<Integer> getAdvertiserIdsByQualifyStatus(@Param("qualifyStatus") Integer qualifyStatus,@Param("expireStatus") Integer expireStatus);

    /**
     * 查出该广告主id集合下的所有资质信息
     * @param
     * @return
     */
    List<TblAdQualify> getQualifyByAdvertiserIds(@Param("advertiserIds") List<Long> advertiserIds);

    /**
     * 资质审核列表
     * @param advertiserId
     * @param auditStatus
     */
    List<AdvertiserQualifyInfoVo> getQualifyAuditList(@Param("advertiserId") Integer advertiserId, @Param("auditStatus") Integer auditStatus, @Param("content") String content);

    List<QualifyTypeStrDTO> getQualifyTypeByAdvertiserIds(@Param("advertiserIds") List<Long> advertiserIds);
}
