package com.bxm.adsmanager.dal.mapper.advertiser.ext;

import com.bxm.adsmanager.dal.mapper.advertiser.TblStationUserWeightMapper;
import com.bxm.adsmanager.model.dao.advertiser.TblStationUserWeight;
import com.bxm.adsmanager.model.vo.advertiser.TblStationUserWeightVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * Description StationUserWeightMapper扩展类
 *
 * @author hxpeng
 * <p>
 * Date 2018/12/11 14:44
 */
public interface TblStationUserWeightMapperExt extends TblStationUserWeightMapper {

    /**
     * Description: 查询列表
     * JDK version used:<JDK1.8>
     * Create Date：2018/12/11 14:46
     *
     * @param advertiserIds 广告主ID集合
     * @param saleCode      销售
     * @return java.util.List<com.bxm.adsmanager.model.vo.advertiser.StationUserWeightVO>
     * @author hxpeng
     */
    List<TblStationUserWeightVO> getList(@Param("advertiserIds") List<Integer> advertiserIds, @Param("saleCode") String saleCode);

    /**
     * Description: 查询正在进行中的站内户权重列表 根据广告主ID
     * JDK version used:<JDK1.8>
     * Create Date：2018/12/11 17:50
     *
     * @param advertiserId 广告主ID
     * @return java.util.List<com.bxm.adsmanager.model.dao.advertiser.StationUserWeight>
     * @author hxpeng
     */
    List<TblStationUserWeight> findEffectiveByAdvertiserId(@Param("advertiserId") Long advertiserId);


    /**
     * Description: 查询一条未完成的 根据广告主ID 和 广告券类型 的权重计划
     * JDK version used:<JDK1.8>
     * Create Date：2018/12/17 14:26
     *
     * @param advertiserId 广告主ID
     * @param tagCode      广告券类型
     * @return com.bxm.adsmanager.model.dao.advertiser.TblStationUserWeight
     * @author hxpeng
     */
    List<TblStationUserWeight> findUnCompleteByAdvertiserAndTagCode(@Param("advertiserId") Long advertiserId, @Param("tagCode") Integer tagCode);

    /**
     * Description: 批量给权重计划 修改状态
     * JDK version used:<JDK1.8>
     * Create Date：2018/12/19 18:15
     *
     * @param ids    权重计划ID集合
     * @param status 状态
     * @return int
     * @author hxpeng
     */
    int batchUpdateStatusByIds(@Param("ids") List<Long> ids, @Param("status") Byte status);

    /**
     * Description: 根据流量包ID 模糊查询 有效（进行中）的站内户权重计划集合
     * JDK version used:<JDK1.8>
     * Create Date：2018/12/20 10:58
     *
     * @param flowPackageId 流量包ID
     * @return java.util.List<com.bxm.adsmanager.model.dao.advertiser.TblStationUserWeight>
     * @author hxpeng
     */
    List<TblStationUserWeight> findEffectiveByFuzzyFlowPackageId(@Param("flowPackageId") String flowPackageId);

    /**
     * Description: 批量修改 权重计划得 流量包数量和ID字符
     * JDK version used:<JDK1.8>
     * Create Date：2018/12/27 19:02

     * @param tblStationUserWeights 权重计划集合
     * @return int
     * @author hxpeng
     */
    int batchUpdateAdFlowPackage(@Param("tblStationUserWeights") List<TblStationUserWeight> tblStationUserWeights);



}
