package com.bxm.adsmanager.dal.mapper.alarm.ext;

import com.bxm.adsmanager.dal.mapper.alarm.AlarmRecordMapper;
import com.bxm.adsmanager.model.dao.alarm.AlarmRecord;
import com.bxm.adsmanager.model.ro.AutoAlarmEditRo;
import com.bxm.adsmanager.model.ro.AutoAlarmRo;
import com.bxm.adsmanager.model.vo.AlarmStatistic;
import com.bxm.adsmanager.model.vo.AutoAlarmVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author yirenjie
 * createDate:  2018/12/5
 */
public interface AlarmRecordMapperExt extends AlarmRecordMapper {

    List<AlarmRecord> queryList(@Param("autoAlarmRo") AutoAlarmRo autoAlarmRo);

    List<AutoAlarmVo> queryListGroupByAppkey(@Param("autoAlarmRo") AutoAlarmRo autoAlarmRo);

    AlarmRecord selectByIdAndUsername(@Param("id") Long id, @Param("username") String username);

    AlarmStatistic statisticAlarm(@Param("username") String username);

    AlarmRecord selectLatestUnprocessed(@Param("username") String username);

    Integer updateByAlarmIdAndUsername(@Param("autoAlarmEditRo") AutoAlarmEditRo autoAlarmEditRo, @Param("username") String username, @Param("ids") List<String> ids);
}
