package com.bxm.adsmanager.dal.mapper.common;

import com.bxm.adsmanager.model.dao.common.Dictionaries;

import java.util.List;

import com.bxm.adsmanager.model.dao.common.DictionaryGroup;
import com.github.pagehelper.PageInfo;
import org.apache.ibatis.annotations.Param;
/**
 * <h3></h3>
 * @author hcmony
 * @since V1.0.0, 2017/12/14 19:11
 */
public interface DictionariesMapper {
    int deleteByPrimaryKey(String id);

    int insert(Dictionaries record);

    int insertSelective(Dictionaries record);

    Dictionaries selectByPrimaryKey(String id);

    int updateByPrimaryKeySelective(Dictionaries record);

    int updateByPrimaryKey(Dictionaries record);

    /**
     * 根据组id查找字典
     * @param typegroupid
     */
    List<Dictionaries> findAll(String typegroupid);

    List<Dictionaries> findByGroupId(@Param("typegroupid")String typegroupid,@Param("keyword")String keyword);

    /**
     * 根据typecode查找字典
     */
    Dictionaries findByCode(@Param("typecode")String typecode,@Param("groupTypeCode")String groupTypeCode);
    

    /**
     * 根据组名称搜索查找字典
     * @param typegroupid
     */
    List<Dictionaries> findByKeywords(@Param("typegroupid")String typegroupid,@Param("keywords")String keywords);

    List<Dictionaries> find();

    int insertTypeGroup(DictionaryGroup dictionaryGroup);

    List<DictionaryGroup> findDictionaryGroup(@Param("keyword")String keyword);

    int findByParam(DictionaryGroup dictionaryGroup);

    int deleteDictionaryGroup(@Param("id")String id);

    int updateDictionaryGroup(DictionaryGroup dictionaryGroup);

    int findByDictionary(Dictionaries dictionaries);

    DictionaryGroup selectDictionaryGroup(String id);

    List<Dictionaries> findDictionaryNoPage(String typeGroupCode);
}