package com.bxm.adsmanager.dal.mapper.config.ext;

import com.bxm.adsmanager.dal.mapper.config.AdPositionConfigMapper;
import com.bxm.adsmanager.model.dao.config.AdPositionConfig;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author yirenjie
 * createDate:  2018/7/17
 */
@Repository
public interface AdPositionConfigMapperExt extends AdPositionConfigMapper {

    /**
     * 根据广告位查询对应所有有效的配置记录
     * @param adPositionId
     * @return
     */
    @Select("select * from ad_position_config where adPositionId=#{adPositionId} and enable=1")
    List<AdPositionConfig> queryEnableListByPositionId(@Param("adPositionId") String adPositionId);

    /**
     * 根据广告位id,配置id查询对应的记录
     * @param adPositionId
     * @param configId
     * @return
     */
    @Select("select * from ad_position_config where adPositionId=#{adPositionId} and configId=#{configId}")
    AdPositionConfig findByPositionAndConfigId(@Param("adPositionId") String adPositionId, @Param("configId") Integer configId);

    @Select("select * from ad_position_config ")
    List<AdPositionConfig> findAll();
}
