package com.bxm.adsmanager.dal.mapper.media;

import com.bxm.adsmanager.model.dao.media.AdMedia;
import com.bxm.adsmanager.model.dao.media.AdMediaPosition;
import com.bxm.adsmanager.model.dao.media.OldTagMsg;
import com.bxm.adsmanager.model.vo.media.MediaTicketVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * @author 阿导
 * @version 1.0
 * @fileName com.bxm.adsmanager.dal.mapper.media.MediaMapper.java
 * @CopyRright (c) 2018-万物皆导
 * @created 2018-04-08 15:08:00
 */
@Repository
public interface MediaMapper {

    /**
     * 查询媒体信息
     *
     * @author 阿导
     * @time 2018/4/9
     * @CopyRight 杭州微财科技有限公司
     * @param keyword
     * @param mjcode
     * @param bdcode
     * @return java.util.List<com.bxm.adsmanager.model.dao.media.AdMedia>
     */
    @Deprecated
    List<AdMedia> queryMedia(@Param("keyword") String keyword,
                             @Param("mjcode") String mjcode,
                             @Param("bdcode") String bdcode,
                             @Param("list") List<String> list,
                             @Param("appkeys") List<String> appkeys,
                             @Param("prepay") Integer prepay);
    /**
     * 查询媒体广告位数目
     *
     * @author 阿导
     * @time 2018/4/9
     * @CopyRight 杭州微财科技有限公司
     * @param appkeys
     * @return java.util.List<com.bxm.adsmanager.model.dao.media.AdMedia>
     */
    @Deprecated
    List<AdMedia> queryPositionCounts(@Param("appkeys") List<String> appkeys);

    /**
     * 查询媒体推广位
     *
     * @author 阿导
     * @time 2018/4/9
     * @CopyRight 杭州微财科技有限公司
     * @param appkey
     * @return java.util.List<com.bxm.adsmanager.model.dao.media.AdMediaPosition>
     */
    @Deprecated
    List<AdMediaPosition> queryMediaPosition(@Param("appkey") String appkey,@Param("keywords") String keywords,@Param("businessList") List<String> businessList);

    /**
     * 查询老表的标签限制
     *
     * @author 阿导
     * @time 2018/4/11
     * @CopyRight 杭州微财科技有限公司
     * @param
     * @return java.util.List<com.bxm.adsmanager.model.dao.media.OldTagMsg>
     */
    List<OldTagMsg> queryOldTag();
    
    /**
     * @description 根据条件查找广告券列表
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param map
     * @return list
     */
    List<MediaTicketVo> findTicketByParam(Map<String,Object> map);

    /**
    *   修改媒体信息
    * @CopyRright  (c) 2018-微财科技有限公司
    * @author sunzhongshu
    * @created 2018/6/4 14:31
    * @modifier sunzhongshu
    */
    
    int positionUpdate(Map<String,Object> map);

    @Deprecated
    int insertMedia(Map<String,Object> map);

    @Deprecated
    int insertPosition(Map<String,Object> map);

    /**
     * 查询媒体广告位信息
     * （不允许再使用，查询广告位请使用AppEntranceFacadeIntegration.getByPositionId）
     *
     * @author 阿导
     * @time 2018/4/9
     * @CopyRight 杭州微财科技有限公司
     * @param appkey
     * @return java.util.List<com.bxm.adsmanager.model.dao.media.AdMediaPosition>
     */
    @Deprecated
    List<AdMediaPosition> queryMediaPosition2(@Param("appkey") String appkey,@Param("business") String business);


}
