package com.bxm.adsmanager.dal.mapper.media;
 
import com.bxm.adsmanager.model.dao.media.AdMediaTest;
import com.bxm.adsmanager.model.vo.media.AdMediaTestVo;
import com.bxm.adsmanager.model.vo.media.MediaTicketVo;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;
 

/**
 * <h3></h3>
 * @author 拉拉
 * @since V1.0.0, 2017/12/14 19:11
 */
@Repository
public interface MediaTestMapper {

    /**
     * @description 批量插入数据
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param list
     * @return void
     */
    void insert(AdMediaTest adMediaTest);
    /**
     * @description 修改数据
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param list
     * @return void
     */
    void update(AdMediaTest adMediaTest);
    
    /**
     * @description 修改状态数据
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param list
     * @return void
     */
    void updateStatus(AdMediaTest adMediaTest);
    /**
     * @description 修改数据
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param list
     * @return void
     */
    void delete(@Param("id")Long  id);
    /**
     * @description 根据入口id查找数量
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param positionId
     * @return Integer
     */
    Integer getCountByPositionId(@Param("positionId")String positionId);

    /**
     * @description 根据条件查找列表
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param map
     * @return list
     */
    List<AdMediaTestVo> findAllByAppKyeOrKeywords(Map<String,Object> map);

    /**
     * @description 根据id查找 
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param positionId
     * @return Integer
     */
    AdMediaTest findAdMediaTestById(@Param("id")Long  id);
    

    /**
     * @description 根据入口id查找 
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param positionId
     * @return Integer
     */
    AdMediaTest findAdMediaTestByPositionId(@Param("positionId")String  position);

    /**
     * @description 根据条件查找广告券列表
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param map
     * @return list
     */
    List<MediaTicketVo> findTicketByParam(Map<String,Object> map);
    /**
     * @description 根据条件查找广告券列表
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param map
     * @return list
     */
    List<AdMediaTest> findAdMediaTestByIsUse();
    /**
     *
     * 条件查找ocpc券
     * */
    List<MediaTicketVo> findOcpcTicketByParam(Map<String,Object> map);

    List<Integer> findOcpcTicketIds();
}