package com.bxm.adsmanager.dal.mapper.mediamanager.ext;

import com.bxm.adsmanager.dal.mapper.mediamanager.AdTicketPositionWeightMapper;
import com.bxm.adsmanager.model.dao.mediamanager.AdTicketPositionWeight;
import com.bxm.adsmanager.model.dto.InfoMediaMsgDto;
import com.bxm.adsmanager.model.dto.InfoPositionMsgDto;
import com.bxm.adsmanager.model.dto.common.CommonSearchDto;
import com.bxm.adsmanager.model.vo.AdTicketPositionWeightVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**  
* @Title: AdTicketPositionWeightMapperExt 
* @Description:  
* @author xavier  
* @date 2018年3月14日  
*/  
public interface AdTicketPositionWeightMapperExt extends AdTicketPositionWeightMapper{
    
    @Deprecated
	List<InfoMediaMsgDto> findMediaByRole(@Param("search") CommonSearchDto search,
										  @Param("roleCode") String roleCode);

    @Deprecated
	List<InfoPositionMsgDto> findPositionByRole(@Param("search") CommonSearchDto search,
									   @Param("roleCode") String roleCode);

	/**  
	 * @Title: findMediaAll  
	 * @Description:  通过关键字查询媒体信息
	 * @author xavier  
	 * @date 2018年3月14日
	 */  
	@Deprecated
	public List<InfoMediaMsgDto> findMediaAll(@Param("search") CommonSearchDto search); 

	/**  
	 * @Title: findMediaAll  
	 * @Description:  通过关键字查询广告位信息
	 * @author xavier  
	 * @date 2018年3月14日
	 */
	@Deprecated
	public List<InfoPositionMsgDto> findPositionAll(@Param("search") CommonSearchDto search); 
	
	/**  
	 * @Title: findAll  
	 * @Description:  查询该渠道所有开启券的权重
	 * @author xavier  
	 * @date 2018年3月14日
	 */  
	public List<AdTicketPositionWeightVo> findAll(@Param("search") CommonSearchDto search);
	
	/**  
	 * @Title: updateFactorByTicket  
	 * @Description:  根据礼券ID修改权重系数
	 * @author xavier  
	 * @date 2018年4月3日
	 */  
	public void updateFactorByTicket(Long ticketId);
	
	/**  
	 * @Title: updateByRecord  
	 * @Description:  修改礼券ARPU值
	 * @author xavier  
	 * @date 2018年4月23日
	 */  
	public void updateByRecord(@Param("record") AdTicketPositionWeight record);
	
	/**  
	 * @Title: getTicketIdsByPosition  
	 * @Description:  通过广告位ID 获取该广告位下的所有礼券信息
	 * @author xavier  
	 * @date 2018年5月26日
	 */  
	public List<Long> getTicketIdsByPosition(@Param("positionId") String positionId);
	
	/**  
	 * @Title: getExistBySearch  
	 * @Description:  通过广告位ID和礼券ID查询是否有记录存在
	 * @author xavier  
	 * @date 2018年5月26日
	 */  
	public int getExistBySearch(@Param("positionId") String positionId,@Param("ticketId")String ticketId);


	/**
	 * @Title: findPositionAll2
	 * @Description:  通过多个AppKey和关键字查询广告位信息
	 * @author wuwenquan
	 * @date 2018年6月25日
	 */
	@Deprecated
	public List<InfoPositionMsgDto> findPositionAll2(Map<String,Object> params);

	/**
	 * @Title: getExistBySearch
	 * @Description:  通过礼券ID查询人工系数大于100%的信息
	 * @author xavier
	 * @date 2018年5月26日
	 */
	public List<AdTicketPositionWeightVo> findWeightMsg(Long ticketId);


    /**
     * Description: 根据广告位ID集合 批量修改 干预系数
     * JDK version used:<JDK1.8>
     * Create Date：2018/12/12 13:57
     *
     * @param ids        广告位权重ID集合
     * @param interventionFactor 干预系数
     * @return java.lang.Integer
     * @author hxpeng
     */
    Integer batchUpdateInterventionFactorByIds(@Param("ids") List<Long> ids,
                                               @Param("interventionFactor") Double interventionFactor);


    /**
     * Description: 根据广告位ID集合 批量判断 然后 修改 干预系数
     * JDK version used:<JDK1.8>
     * Create Date：2018/12/14 10:55
     *
     * @param ids           广告位ID集合
     * @param oldInterventionFactor 旧干预系数
     * @param newInterventionFactor 新干预系数
     * @return java.lang.Integer
     * @author hxpeng
     */
    Integer batchCompareAndUpdateInterventionFactorByIds(@Param("ids") List<Long> ids,
                                                         @Param("oldInterventionFactor") Double oldInterventionFactor,
                                                         @Param("newInterventionFactor") Double newInterventionFactor);

    /**
     * Description: 根据广告位ID集合批量查询
     * JDK version used:<JDK1.8>
     * Create Date：2018/12/13 10:11

     * @param positionIds 广告位ID集合
     * @return java.util.List<com.bxm.adsmanager.model.dao.mediamanager.AdTicketPositionWeight>
     * @author hxpeng
     */
    List<AdTicketPositionWeight> findAllByPositionIds(@Param("positionIds") Set<String> positionIds);

    /**
     * Description: 根据单个券ID 批量查询所有的广告位权重
     * JDK version used:<JDK1.8>
     * Create Date：2018/12/25 13:37

     * @param ticketId 券ID
     * @return java.util.List<com.bxm.adsmanager.model.dao.mediamanager.AdTicketPositionWeight>
     * @author hxpeng
     */
    List<AdTicketPositionWeight> findAllByTicketId(@Param("ticketId") Long ticketId);

    /**
     * Description: 批量新增
     * JDK version used:<JDK1.8>
     * Create Date：2018/12/14 10:33
     *
     * @param adTicketPositionWeights 权重集合
     * @return int
     * @author hxpeng
     */
    int batchInsert(@Param("adTicketPositionWeights") List<AdTicketPositionWeight> adTicketPositionWeights);

}