package com.bxm.adsmanager.dal.mapper.menu.ext;

import com.bxm.adsmanager.dal.mapper.menu.AdMenuMapper;
import com.bxm.adsmanager.model.vo.AdMenuVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

public interface AdMenuMapperExt extends AdMenuMapper{
	/**
	 * @description 查询所有的父节点菜单
	 * @author xw
	 * @date 2018/4/11 9:54
	 * @param
	 * @return java.util.List<com.bxm.adsmanager.model.vo.AdMenuVo>
	 */
	List<AdMenuVo> selectAllParentMenu();

	/**
	 * @description 根据父节点ID查询子菜单
	 * @author xw
	 * @date 2018/4/11 9:53
	 * @param parentId
	 * @return java.util.List<com.bxm.adsmanager.model.vo.AdMenuVo>
	 */
	List<AdMenuVo> selectMenuByParentId(@Param("parentId") Long parentId);

	/**
	 * @description 根据父节点ID和names查询子菜单
	 * @author xw
	 * @date 2018/4/11 11:51
	 * @param parentId
	* @param nameSet
	 * @return java.util.List<com.bxm.adsmanager.model.vo.AdMenuVo>
	 */
	List<AdMenuVo> selectMenuByParentIdAndNames(@Param("parentId") Long parentId, @Param("nameSet") Set<String> nameSet);

	/**
	 * @description 根据menu_code查询菜单
	 * @author xw
	 * @date 2018/4/11 11:18
	 * @param menuCodes
	 * @return java.util.List<com.bxm.adsmanager.model.vo.AdMenuVo>
	 */
	List<AdMenuVo> selectMenuParentByMenuCodeSet(@Param("menuCodes") Set<String> menuCodes);
}
