package com.bxm.adsmanager.dal.mapper.tbltag.ext;

import com.bxm.adsmanager.dal.mapper.tbltag.TblAdPostionTagMapper;
import com.bxm.adsmanager.model.dao.tbltag.TblAdPostionTag;
import com.bxm.adsmanager.model.dto.tbltag.AdTagNameTicketAuditDTO;
import com.bxm.adsmanager.model.vo.tbltag.TblAdTagVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * @author gaoshihao
 * @version v1.1.4_Report
 * @fileName com.bxm.adsmanager.dal.mapper.tbltag.ext.TblAdTagMapperExt.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2018-04-25 18:41:00
 * @modifier gaoshihao
 * @updated 2018-04-25 18:41:00
 */
@Component
public interface TblAdPostionTagMapperExt extends TblAdPostionTagMapper {

    /**
     * 查询所有列表
     *
     * @param parentId
     * @param typeTag
     * @return
     */
    public List<TblAdTagVo> findTblAdTagList(@Param("parentId") Integer parentId, @Param("typeTag") Integer typeTag, @Param("name") String name);

    /**
     * 查询最大的code
     *
     * @return
     */
    Integer findMaxCode();

    /**
     * 根据名字查询子集合
     *
     * @param condition
     * @return
     */
    List<TblAdTagVo> findTblAdTagChildByName(@Param("condition") Map<String, String> condition);


    /**
     * 根据名字 查询实体
     *
     * @param condition
     * @return
     */
    TblAdTagVo findTblAdTagByName(@Param("condition") Map<String, String> condition);


    /**
     * 根据名字 查询实体
     *
     * @param condition
     * @return
     */
    List<TblAdTagVo> findAll();


    /**
     * 根据名字 查询实体
     *
     * @param condition
     * @return
     */
    List<TblAdTagVo> findTblAdTagByTagList(Map<String, Object> map);

    /**
     * Description: 根据code 查询一条记录
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/7/24 10:20
     */
    TblAdTagVo findByCode(@Param("code") Integer code);

    /**
     * 根据code查询实体
     *
     * @param
     * @return
     */
    @Select("select * from tbl_ad_position_tag where code=#{code};")
    TblAdTagVo findTblAdTagByCode(@Param("code") Integer code);

    //根据主键id查询实体
    TblAdTagVo findByPrimaryId(@Param("id") Integer id);

    /**
     * Description: 批量修改标签
     * JDK version used:<JDK1.8>
     * Create Date：2018/11/26 18:04

     * @param tblAdPostionTags
     * @return int
     * @author hxpeng
     */
    int batchUpdateTag(@Param("tags") List<TblAdPostionTag> tblAdPostionTags, @Param("modifier") String modifier);


    /**
     * Description: 根据CODE 集合 批量查询
     * JDK version used:<JDK1.8>
     * Create Date：2018/12/18 17:35

     * @param codes code 集合
     * @return java.util.List<com.bxm.adsmanager.model.vo.tbltag.TblAdTagVo>
     * @author hxpeng
     */
    List<TblAdTagVo> findAllByCodes(@Param("codes") List<Integer> codes);

    //全路径精确查询
    TblAdTagVo findByFullCode(@Param("fullPath") String fullPath);

    /**
     * 查找所有分类标签
     * @return
     */
    List<TblAdTagVo> findAllClassTag();

    /**
     * 根据券id集合查出对应的标签名字按逗号分隔
     * @param ticketIds
     * @return
     */
    List<AdTagNameTicketAuditDTO> findTagNamesByTicketIds(@Param("ticketIds") List<Long> ticketIds);

    /**
     * 根据券id集合查出对应的标签code按逗号分隔
     * @param ticketIds
     * @return
     */
    List<AdTagNameTicketAuditDTO> findTagCodeByTicketIds(@Param("ticketIds") List<Long> ticketIds);
}
