package com.bxm.adsmanager.integration.admanager.service;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */


import com.bxm.adsmanager.integration.exception.PushAdmanagerException;
import com.bxm.adsmanager.integration.resttemplate.RestTemplateClient;
import com.bxm.adsmanager.integration.utils.WarnMsgUtils;
import com.bxm.util.StringUtil;
import com.google.common.collect.Lists;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.*;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import java.io.IOException;
import java.util.Map;
import java.util.Set;


/**
 * <h3>推送数据到老系统</h3>
 * <p></p>
 * @author hcmony
 * @since V1.0.0, 2018/01/04 22:18
 */
@Configuration
@Component
public class AdmanagerPusherIntegration {

	@Value("${admanager.url}")
	private String admanagerUrl;
	@Value("${admanager.isDD}")
	private int isDD;

	private static final String DDJobUrl = "https://oapi.dingtalk.com/robot/send?access_token=286c319d5372a26356c61106c129286a5535269896273bc0857d57d576c7ba62";

	private static final Logger logger = Logger.getLogger(AdmanagerPusherIntegration.class);
	@Autowired
	private RestTemplateClient restTemplateClient;

	private int num = 0;

	/**
	 * 推送数据到老系统
	 * @return 推送反馈结果
	 */
	@Async
	public void pushToAdmanager(Map<String,Object> map) throws IOException{
		try {
			long start = System.currentTimeMillis();
			String result = restTemplateClient.getByParams(
					"http://"+admanagerUrl + "/infoActivityCertificateNewController.do?saveOrUpdateCertificate", map,HttpMethod.POST,null);
			//String result = postForRest("http://"+admanagerUrl + "infoActivityCertificateNewController.do?saveOrUpdateCertificate", map);
			JSONObject object = JSONObject.fromObject(result);
			String ss = object.getString("success");
			if (StringUtil.isBlank(ss)||!"true".equals(ss)){
				if(num<4){
					num++;
					pushToAdmanager(map);
				}else {
					throw new PushAdmanagerException("推送数据到老系统失败");
				}
			}
			num=0;
			long end = System.currentTimeMillis();
			logger.info("推送数据到老系统id="+map.get("id")+",用时"+(end-start)+"毫秒");
		}catch (Exception e){
			num=0;
			logger.error("推送数据到老系统id="+map.get("id")+",失败",e);
			if(1==isDD){
				WarnMsgUtils.sendDdMsg(DDJobUrl,"推送数据到老系统id="+map.get("id")+",失败", false, null);
			}
		}

	}

	/**
	 * @description
	 * @author hcmony
	 * @time 2018/1/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param url
	 * @param params
	 * @return java.lang.String
	 */
	public static String postForRest(String url, Map<String, Object> params) throws IOException {

		RestTemplate client = new RestTemplate();
		HttpHeaders headers = new HttpHeaders();
		//  请勿轻易改变此提交方式，大部分的情况下，提交方式都是表单提交
		headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
		//  封装参数，千万不要替换为Map与HashMap，否则参数无法传递

		LinkedMultiValueMap<String, String> p = new LinkedMultiValueMap<>();
		Set<Map.Entry<String, Object>> entries = params.entrySet();
		for (Map.Entry<String, Object> entry : entries) {
			Object value = entry.getValue();
			if (null != value){
				p.put(entry.getKey(), Lists.newArrayList(value.toString()));
			}
		}

		HttpEntity<MultiValueMap<String, String>> requestEntity = new HttpEntity<MultiValueMap<String, String>>(p, headers);
		//  执行HTTP请求
		ResponseEntity<String> response = client.exchange(url, HttpMethod.POST, requestEntity, String.class);
		return response.getBody();
	}
}

