/*
 * Copyright ${YEAR} bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.adsmanager.integration.adsprod.service;

import com.alibaba.dubbo.config.annotation.Reference;
import com.bxm.adsprod.facade.advertiser.AdvertiserService;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

import java.math.BigInteger;

/**
 * <h3>advertiser service integration</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/28
 */
@Component
public class ProdAdvertiserIntegration {

    @Reference(version = "1.0.0")
    private AdvertiserService advertiserService;

    private static final Logger logger = Logger.getLogger(ProdAdvertiserIntegration.class);

    /**
     * <p>增加广告主余额</p>
     * 这个接口执行后只会对实时监控的数据有效，不会对广告主本身的余额产生变化。一般在后台对广告主余额进行充值后进行调用，达到前后台数据一致的目的。
     *
     * @param advertiserId
     * @param incValue
     * @return
     */
    public Long incrementBalance(BigInteger advertiserId, Long incValue) {
        logger.info("增加广告主余额id="+advertiserId+",金额="+incValue);
        return advertiserService.incrementBalance(advertiserId, incValue);
    }
}
