package com.bxm.adsmanager.integration.adsprod.service;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */


import com.alibaba.dubbo.config.annotation.Reference;
import com.alibaba.dubbo.config.spring.context.annotation.DubboComponentScan; 
import com.bxm.adsprod.facade.media.PositionGroupService;  
import org.apache.log4j.Logger; 
import org.springframework.stereotype.Component;

import java.math.BigInteger;
import java.util.Map;

/**
 * <h3>从prod获取数据</h3>
 * <p></p>
 * @author 拉拉
 * @since V1.0.0, 2017/12/18 17:11
 */
@Component
@DubboComponentScan
public class ProdPositonGroupIntegration {

	private static final Logger logger = Logger.getLogger(ProdPositonGroupIntegration.class);

	private static final int DEFULT = 0;

    @Reference(version = "1.0.0",check = false)
    private PositionGroupService positionGroupService;	
	

	/**
	 * @description 获取这个广告券所配置的广告位组的今日消耗。
	 * @author 拉拉
	 * @time 2017/12/19
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param ticketId
	 * @return java.lang.Long
	 */
	public  Map<String, Long> getBudgetOfToday(Long ticketId){
		return positionGroupService.getBudgetOfToday(BigInteger.valueOf(ticketId));
	}
  

    /**
     * 获取这个广告券指定广告位组的今日消耗
     *
     * @param ticketId
     * @param groupId
     * @return
     */
	public long getBudgetOfToday(BigInteger ticketId, String groupId) {
        return positionGroupService.getBudgetOfToday(ticketId,groupId);
    };

    /**
     * 为广告券的广告位组增加今日消耗。如果这个广告位在这个广告券中有组织，那么才会增加，否则直接返回 0
     *
     * @param ticketId
     * @param position
     * @param incValue
     * @return
     */
    public long incrementIfNecessary(BigInteger ticketId, String position, long incValue) {
        return  positionGroupService.incrementIfNecessary(ticketId,  position,  incValue);
    };

    /**
     * 为广告券的广告位组增加今日消耗
     *
     * @param ticketId
     * @param groupId
     * @param incValue 增量值
     * @return
     */
    public long increment(BigInteger ticketId, String groupId, long incValue) {
        return positionGroupService.increment(ticketId, groupId, incValue);
    };
	

}
