package com.bxm.adsmanager.integration.adsprod.service;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */


import com.alibaba.dubbo.config.annotation.Reference;
import com.alibaba.dubbo.config.spring.context.annotation.DubboComponentScan;
import com.bxm.adsprod.facade.advertiser.AdvertiserService; 
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketStatisticsService;
import com.bxm.warcar.cache.Fetcher;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

/**
 * <h3>从prod获取数据</h3>
 * <p></p>
 * AD:COUNTER:DAILY_BUDGET:${yyyyMMdd}	累计日预算		10d	HASH	${ticket_id}	-	Long
 * AD:COUNTER:VIEW:${yyyyMMdd}          累计日曝光次数		10d	HASH	${ticket_id}	-	Long
 * AD:COUNTER:CLICK:${yyyyMMdd}	        累计日点击次数 	10d	HASH	${ticket_id}	-	Long
 * @author hcmony
 * @since V1.0.0, 2017/12/18 17:11
 */
@Component
@DubboComponentScan
public class ProdPullerIntegration {

	private static final Logger logger = Logger.getLogger(ProdPullerIntegration.class);

	private static final int DEFULT = 0;

	@Autowired
	@Qualifier("jedisFetcher")
	private Fetcher fetcher;
	@Reference(version = "1.0.0",check = false)
	private AdvertiserService advertiserService;
	@Reference(version = "1.0.0",check = false)
	private TicketStatisticsService ticketStatisticsService;

	

	/**
	 * @description 获取广告券当天已经消耗的日预算
	 * @author hcmony
	 * @time 2017/12/19
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param ticketId
	 * @return java.lang.Long
	 */
	public Long getBudgetOfToday(Long ticketId){
		return ticketStatisticsService.getBudgetOfToday(BigInteger.valueOf(ticketId));
	}

	/**
	 * 返回广告券今日指定时间段的已用预算
	 * @param ticketId
	 * @param startHour
	 * @param endHour
	 * @return
	 */
	public long getBudgetOfTimeline(BigInteger ticketId, int startHour, int endHour) throws IllegalArgumentException{
		return ticketStatisticsService.getBudgetOfTimeline(ticketId, startHour,endHour);
	}

	/**
	 * @description 获取广告主余额
	 * @author hcmony
	 * @time 2017/12/19
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param advertiserId
	 * @return java.lang.Long
	 */
	public Long getAdvertiserBalance(Long advertiserId){
		return advertiserService.getAdvertiserBalance(BigInteger.valueOf(advertiserId));
	}


	/**
	 * @description 根据时间获取当天的日预算
	 * @author hcmony
	 * @time 2017/12/19
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param ticketId 	券id
	 * @param dateStr   字符串时间
	 * @return java.lang.Long
	 */
	public Integer fetchBudgetOfDailyCount(String ticketId,String dateStr){

		try {
			Integer budgetOfDaily = fetcher.hfetch(TicketKeyGenerator.Statistics.getBudgetOfDaily(dateStr), ticketId, null, Integer.class);
			return budgetOfDaily==null?DEFULT:budgetOfDaily;
		}catch (Exception e){
			logger.error("根据时间获取当天的日预算出错"+e.getMessage(),e);
			return DEFULT;
		}


	}

	/**
	 * @description 根据时间获取当天的曝光量
	 * @author hcmony
	 * @time 2017/12/19
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param ticketId 	券id
	 * @param dateStr   字符串时间
	 * @return java.lang.Long
	 */
	public Integer fetchOpenPvCount(String ticketId,String dateStr){

		try {
			Integer budgetOfDaily = fetcher.hfetch(TicketKeyGenerator.Statistics.getViewOfDaily(dateStr), ticketId, null, Integer.class);
			return budgetOfDaily==null?DEFULT:budgetOfDaily;
		}catch (Exception e){
			logger.error("根据时间获取当天的曝光量出错"+e.getMessage(),e);
			return DEFULT;
		}
	}

	/**
	 * @description 根据时间获取当天的点击量
	 * @author hcmony
	 * @time 2017/12/19
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param ticketId 	券id
	 * @param dateStr   字符串时间
	 * @return java.lang.Long
	 */
	public Integer fetchClikePvCount(String ticketId,String dateStr){

		try {
			Integer budgetOfDaily = fetcher.hfetch(TicketKeyGenerator.Statistics.getClickOfDaily(dateStr), ticketId, null, Integer.class);
			return budgetOfDaily==null?DEFULT:budgetOfDaily;
		}catch (Exception e){
			logger.error("根据时间获取当天的点击量出错"+e.getMessage(),e);
			return DEFULT;
		}
	}
	  /**
	   * @description 根据时间素材所有的点击量
	   * @author 拉拉
	   * @time  2018/04/02
	   * @CopyRight 杭州微财网络科技有限公司
	   * @param assetsId  素材id 
	   * @return java.lang.Long
	   */
    public Integer fetchAssetAllClikePvCount(Long assetsId ){

        try {
            Integer allClickCount = fetcher.fetch(TicketKeyGenerator.Statistics.getTicketAllAssetsClick(BigInteger.valueOf(assetsId)),null , Integer.class);
            return allClickCount==null?DEFULT:allClickCount;
        }catch (Exception e){
            logger.error("根据获取点击量出错"+e.getMessage(),e);
            return DEFULT;
        }
    }
   
    /**
     * @description 根据时间素材所有的点击量
     * @author 拉拉
     * @time  2018/04/02
     * @CopyRight 杭州微财网络科技有限公司
     * @param assetsId  素材id 
     * @return java.lang.Long
     */
  public Integer fetchAssetAllViewPvCount(Long assetsId){

      try {
          Integer allViewCount = fetcher.fetch(TicketKeyGenerator.Statistics.getTicketAllAssetsView(BigInteger.valueOf(assetsId)),null , Integer.class);
          return allViewCount==null?DEFULT:allViewCount;
      }catch (Exception e){
          logger.error("根据获取点击量出错"+e.getMessage(),e);
          return DEFULT;
      }
  }   
  /**
   * @description 根据时间素材所有的点击量
   * @author 拉拉
   * @time  2018/04/02
   * @CopyRight 杭州微财网络科技有限公司
   * @param assetsId  素材id 
   * @return java.lang.Long
   */
  public Integer fetchAssetValiedClikePvCount(Long assetsId ){

      try {
          Integer allValiedClickCount = fetcher.fetch(TicketKeyGenerator.Statistics.getTicketAllAssetsValidClick(BigInteger.valueOf(assetsId)),null , Integer.class);
          return allValiedClickCount==null?DEFULT:allValiedClickCount;
      }catch (Exception e){
          logger.error("根据获取点击量出错"+e.getMessage(),e);
          return DEFULT;
      }
  }
	
  /**
   * @description 根据某个广告位的所有曝光
   * @author 拉拉
   * @time  2018/04/02
   * @CopyRight 杭州微财网络科技有限公司
   * @param positionId  入口id
   * @return java.lang.Long
   */
  public Map<String, Long> fetchPositionTestViewPvCount(String positionId){

      try {
          Map<String, Long> map = fetcher.hfetchall(TicketKeyGenerator.Statistics.getPositionIdTestViews(positionId),null , Long.class);
          return map;
      }catch (Exception e){
          logger.error("根据获取点击量出错"+e.getMessage(),e);
          return new HashMap<>();
      }
  }
    

}
