package com.bxm.adsmanager.integration.adsprod.service;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */


import com.alibaba.dubbo.config.annotation.Reference;
import com.alibaba.dubbo.config.spring.context.annotation.DubboComponentScan;
import com.bxm.adsprod.facade.commons.CachePushableService;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * <h3>推送数据到前端</h3>
 * <p>将数据推送到<code>serviceName</code>服务，对应的服务接收到请求后，
 * 会根据<code>parameters</code>参数约定来生成缓存的KEY，最后将<code>data</code>数据更新到缓存中。</p>
 *   				     服务名           			参数列表					com.bxm.adsprod.facade.rules.
 * 1 广告券地域规则	  	TICKET_REGION				ticketid				TicketRegionRule
 * 2 广告券广告位规则	 	TICKET_POSITION				ticketid				TicketPositionRule
 * 3 广告券时间段规则		TICKET_TIMELINE				ticketid				TicketTimelineRule
 * 4 广告位行业地域规则 	POSITION_DOMAIN_REGION  	positionid domaincode	 PositionDomainRegionRule
 * 5 广告位标签地域规则 	POSITION_TAG_REGION 		positionid tagcode 		PositionTagRegionRule
 * 6 自有产品规则
 * 7 广告券频次规则 		TICKET_TIMES 				ticketid         		TicketTimesRule
 * 8 广告券用户画像评分结果 	TICKET_USER_GRADE 			imei 					UserGrade
 * 9 有效广告券列表 		VALID_TICKETS                     				Ticket[]
 * 10 广告券      		TICKET    					ticketid				Ticket
 * 11 所有广告券 			ALL_TICKETS 									Ticket[]
 * 12 广告券价格配置		TICKET_PRICE 				ticketid 				TICKET_PRICE[]
 * 13 广告券权重手动干预系数 TICKET_MIF  				ticketid  				TicketWeightMif[]
 * 14 CPA广告券消耗 		TICKET_PROFIT_FOR_CPA 							TicketProfitForCpa[]
 * 15 广告主充值余额额度  	ADVERTISER_RECHARGE_BALANCE advertiserid  		String - 本次充值金额，单位：厘
 *
 * @author hcmony
 * @since V1.0.0, 2017/12/15 11:18
 */

@Component
@DubboComponentScan
public class ProdPusherIntegration {

	private static final Logger logger = Logger.getLogger(ProdPusherIntegration.class);

	@Reference(version = "1.0.0",check = false)
	private CachePushableService cachePushableService;

	/**
	 * 推送数据到前端
	 * @param serviceName 服务名
	 * @param parameters 参数
	 * @param data 数据
	 * @return 推送反馈结果
	 */
	public String pushToProd(String serviceName, Map<String, Object> parameters, byte[] data)throws Exception{
		logger.info("推送数据到前端serviceName="+serviceName);
		return cachePushableService.push(serviceName,parameters,data);
	}
}
