package com.bxm.adsmanager.integration.advertiser.service;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserFinanceDto;
import com.bxm.adsmanager.integration.advertiser.model.Pagination;
import com.bxm.adsmanager.integration.resttemplate.RestTemplateClient;
import com.bxm.profit.facade.AdIncomeService;

import com.bxm.util.OkHttpUtils;
import com.bxm.util.StringUtil;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <h3></h3>
 * @author hcmony
 * @since V1.0.0, 2017/12/14 19:11
 */
@Configuration
@Component
public class AdShopIntegration {

	@Value("${adShopUrl}")
	private  String host;

	private static final Logger logger = Logger.getLogger(AdShopIntegration.class);
	@Autowired
	private RestTemplateClient restTemplateClient;

	/**
	 * 获取广告主接口地址
	 */
	public  String getAdShopUrl() {
		return "http://" + host + ":18181";
	}

	/**
	 * 接口获取广告主列表
	 */
	public  List<AdvertiserDto> getAdShopList(AdvertiserDto search) throws Exception {
		Map<String, Object> param = new HashMap<String, Object>();
		param.put("isAdSystem", 1);
		if (StringUtil.isNotEmpty(search.getCompany())) {
			param.put("keywords", search.getCompany());
		}
		if (search.getAccountType() != null) {
			param.put("accountType", search.getAccountType());
		}
		if (StringUtil.isNotEmpty(search.getAe())) {
			param.put("ae", search.getAe());
		}
		if (StringUtil.isNotEmpty(search.getSale())) {
			param.put("sale", search.getSale());
		}
		if (search.getId() != null) {
			param.put("id", search.getId());
		}

		long start = System.currentTimeMillis();
		String httpResult = OkHttpUtils.get(getAdShopUrl() + "/getList", param);
		//String httpResult = restTemplateClient.getByParams(getAdShopUrl() + "/getList", param, HttpMethod.GET, MediaType.APPLICATION_JSON);
		//logger.info("接口获取广告主时间："+(System.currentTimeMillis()-start));
		start = System.currentTimeMillis();
		com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject(httpResult);
		com.alibaba.fastjson.JSONArray json = jsonObject.getJSONArray("returnValue");
		List<AdvertiserDto> lists = json.toJavaList(AdvertiserDto.class);
		//logger.info("广告主序列化时间："+(System.currentTimeMillis()-start));
		return lists;
	}

	/**
	 * 获取所有的广告主集合
	 * @return
	 * @throws Exception
	 */
	public Map<Integer,String> getAllAdvertiserMap() throws Exception {

		List<AdvertiserDto> adShopList = getAdShopList(new AdvertiserDto());

		Map<Integer,String> map = new HashMap<Integer, String>();
		if (CollectionUtils.isNotEmpty(adShopList)){
			adShopList.forEach(e->map.put(e.getId(),e.getCompany()));
		}
		return map;
	}



	/**
	 * 接口获取广告主列表 (真)分页
	 */
	public  Pagination getAdvertiserPage(Map<String, Object> param) throws Exception {
		param.put("isAdSystem", 1);
		String httpResult = OkHttpUtils.get(getAdShopUrl() + "", param);
		//String httpResult = restTemplateClient.getByParams(getAdShopUrl(), param, HttpMethod.GET, MediaType.APPLICATION_JSON);
		com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject(httpResult);
		com.alibaba.fastjson.JSONObject json = jsonObject.getJSONObject("returnValue");
		Pagination pageBean = new Pagination();
		pageBean.setTotalCount(json.getInteger("total"));
		pageBean.setPageNo(json.getInteger("pageNum"));
		pageBean.setPageSize(json.getInteger("pageSize"));
		com.alibaba.fastjson.JSONArray  jsons = json.getJSONArray("list");
		List<AdvertiserDto> lists = jsons.toJavaList(AdvertiserDto.class);
		pageBean.setList(lists);
		return pageBean;
	}

	/**
	 * 根据广告主ID,查询广告主信息
	 *
	 * @throws IOException
	 */
	public  List<AdvertiserDto> findAdShopMsgs(String ids) throws IOException {
		Map<String, Object> param = new HashMap<String, Object>();
		param.put("ids", ids);
		//String result = OkHttpUtils.get(getAdShopUrl() + "/getListByIds/?ids=" + ids);
		String result =(String) restTemplateClient.getNoParams(getAdShopUrl() + "/getListByIds/?ids=" + ids,String.class);
		List<AdvertiserDto> record = JSON.parseArray(JSON.parseObject(result).getString("returnValue"), AdvertiserDto.class);
		return record;
	}

	/**
	 * 添加广告主收益(返回值)
	 *
	 * @throws IOException
	 */
	public  String addAdShopCashNew(AdvertiserFinanceDto record) throws IOException {
		String result =  OkHttpUtils.post(getAdShopUrl() + "/advertiserFinance", JSON.toJSONString(record));
		if(StringUtil.isNotEmpty(result)){
			com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONArray.parseObject(result);
			return jsonObject.getString("successed");
		}else{
			return null;
		}
	}


	/**
	 * 根据广告主ID,查询广告主信息
	 *
	 * @throws IOException
	 */
	public  AdvertiserDto findAdShopMsg(long id) throws IOException {
		String result = OkHttpUtils.get(getAdShopUrl() + "/get/" + id);
		com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONArray.parseObject(result);
		return (AdvertiserDto)jsonObject.get("returnValue");
	}

	/**
	 * 添加广告主收益
	 * 
	 * @throws IOException
	 */
	public  boolean addAdShopCash(AdvertiserFinanceDto record) throws IOException {
		boolean flag = false;
		String result = OkHttpUtils.post(getAdShopUrl() + "/advertiserFinance", JSON.toJSONString(record));
		JSONObject object = JSONObject.fromObject(result);
		String ss = object.getString("successed");
		if("true".equals(ss)){
			flag = true;
		}
		return flag;
	}
}
