/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.adsmanager.integration.common.service;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserFinanceDto;
import com.bxm.adsmanager.integration.advertiser.model.Pagination;
import com.bxm.adsmanager.integration.resttemplate.RestTemplateClient;
import com.bxm.util.HttpUtil;
import com.bxm.util.MD5Util;
import com.google.common.collect.Maps;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <h3>公共模块</h3>
 * @author hcmony
 * @since V1.0.0, 2018/12/14 19:11
 */
@Configuration
@Component
public class CommonIntegration {

	@Value("${public.url}")
	private  String host;

	private static final Logger logger = Logger.getLogger(CommonIntegration.class);
	private static final String appSecret = "oWc0jGVZn9Aqo5uXN4duvwbQqHQ1Gamk";

	@Autowired
	private RestTemplateClient restTemplateClient;

	/**
	 * 获取地址
	 */
	public  String getUrl() {
		return "http://" + host + "/";
	}

	/**
	 * 同步公共模块数据
	 */
	public  String sendToCommon(HashMap<String, Object> param){
		try {
			// 同步公共模块数据
			String url = getUrl();
			param.put("sign", MD5Util.sign(param, appSecret));
			String httpResult = restTemplateClient.getByParams(url,param, HttpMethod.POST, MediaType.APPLICATION_JSON);
			return  httpResult;
		}catch (Exception e){
			logger.error("同步公共模块数据",e);
			return "";
		}
	}
}
