/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with http://www.bianxianmao.com.
 */

package com.bxm.adsmanager.integration.datapark.model;

import com.bxm.adsmanager.integration.utils.DataParkUtils;

/**
 * 活动报表实体类
 *
 * @author 阿导
 * @version BUILD1001
 * @fileName com.bxm.datapark.dal.mongo.vo.ActivityCount.java
 * @CopyRright (c) 2018-杭州微财科技有限公司
 * @created 2018-02-07 09:43:00
 * @modifier 阿导
 * @updated 2018-02-07 09:43:00
 */
public class ActivityCount {

    /**
     * 编号
     */
    private String number;

    /**
     * 日期
     */
    private String datetime;
    /**
     * 活动 ID
     */
    private Long activityId;

    /**
     * 开发者标志
     */
    private String appKey;

    /**
     * 子渠道标志
     */
    private String business;

    /**
     * 活动首页 PV
     */
    private Integer indexPv;

    /**
     * 活动首页 PV 涨幅
     */
    private String indexPvChange;

    /**
     * 活动首页 UV
     */
    private Integer indexUv;

    /**
     * 活动首页 UV 涨幅
     */
    private String indexUvChange;

    /**
     * 参与次数
     */
    private Integer joinPv;


    /**
     * 参与次数涨幅
     */
    private String joinPvChange;

    /**
     * 参与次数
     */
    private Integer joinUv;

    /**
     * 参与次数涨幅
     */
    private String joinUvChange;

    /**
     * 参与率
     */
    private Double joinRate;
    /**
     * 参与率显示字段
     */
    private String joinRateShow;

    /**
     * 参与率涨幅
     */
    private String joinRateChange;

    /**
     * 发券请求
     */
    private Integer sendPv;
    /**
     * 发券请求涨幅
     */
    private String sendPvChange;


    /**
     * 人均发券
     */
    private Double avgCoupons;

    /**
     * 人均发券涨幅
     */
    private String avgCouponsChange;

    /**
     * 重复发券
     */
    private Double repeatCoupons;

    /**
     * 重复发券涨幅
     */
    private String repeatCouponsChange;

    /**
     * 发券量
     */
    private Integer openPv;

    /**
     * 发券量涨幅
     */
    private String openPvChange;

    /**
     * 点击量
     */
    private Integer clickPv;

    /**
     * 点击量涨幅
     */
    private String clickPvChange;


    public String getDatetime() {
        return datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public Integer getIndexPv() {
        return indexPv;
    }

    public void setIndexPv(Integer indexPv) {
        this.indexPv = indexPv;
    }

    public String getIndexPvChange() {
        return indexPvChange;
    }

    public void setIndexPvChange(String indexPvChange) {
        this.indexPvChange = indexPvChange;
    }

    public Integer getIndexUv() {
        return indexUv;
    }

    public void setIndexUv(Integer indexUv) {
        this.indexUv = indexUv;
    }

    public String getIndexUvChange() {
        return indexUvChange;
    }

    public void setIndexUvChange(String indexUvChange) {
        this.indexUvChange = indexUvChange;
    }

    public Integer getJoinPv() {
        return joinPv;
    }

    public void setJoinPv(Integer joinPv) {
        this.joinPv = joinPv;
    }

    public String getJoinPvChange() {
        return joinPvChange;
    }

    public void setJoinPvChange(String joinPvChange) {
        this.joinPvChange = joinPvChange;
    }

    public Integer getJoinUv() {
        return joinUv;
    }

    public void setJoinUv(Integer joinUv) {
        this.joinUv = joinUv;
    }

    public String getJoinUvChange() {
        return joinUvChange;
    }

    public void setJoinUvChange(String joinUvChange) {
        this.joinUvChange = joinUvChange;
    }

    public Double getJoinRate() {
        return joinRate;
    }

    public void setJoinRate(Double joinRate) {
        this.joinRate = joinRate;
    }

    public String getJoinRateChange() {
        return joinRateChange;
    }

    public void setJoinRateChange(String joinRateChange) {
        this.joinRateChange = joinRateChange;
    }

    public Integer getSendPv() {
        return sendPv;
    }

    public void setSendPv(Integer sendPv) {
        this.sendPv = sendPv;
    }

    public String getSendPvChange() {
        return sendPvChange;
    }

    public void setSendPvChange(String sendPvChange) {
        this.sendPvChange = sendPvChange;
    }

    public Double getAvgCoupons() {
        return avgCoupons;
    }

    public void setAvgCoupons(Double avgCoupons) {
        this.avgCoupons = avgCoupons;
    }

    public String getAvgCouponsChange() {
        return avgCouponsChange;
    }

    public void setAvgCouponsChange(String avgCouponsChange) {
        this.avgCouponsChange = avgCouponsChange;
    }

    public Double getRepeatCoupons() {
        return repeatCoupons;
    }

    public void setRepeatCoupons(Double repeatCoupons) {
        this.repeatCoupons = repeatCoupons;
    }

    public String getRepeatCouponsChange() {
        return repeatCouponsChange;
    }

    public void setRepeatCouponsChange(String repeatCouponsChange) {
        this.repeatCouponsChange = repeatCouponsChange;
    }

    public Integer getOpenPv() {
        return openPv;
    }

    public void setOpenPv(Integer openPv) {
        this.openPv = openPv;
    }

    public String getOpenPvChange() {
        return openPvChange;
    }

    public void setOpenPvChange(String openPvChange) {
        this.openPvChange = openPvChange;
    }

    public Integer getClickPv() {
        return clickPv;
    }

    public void setClickPv(Integer clickPv) {
        this.clickPv = clickPv;
    }

    public String getClickPvChange() {
        return clickPvChange;
    }

    public void setClickPvChange(String clickPvChange) {
        this.clickPvChange = clickPvChange;
    }

    public String getJoinRateShow() {
        return DataParkUtils.getPercent(joinRate);
    }

    public void setJoinRateShow(String joinRateShow) {
        this.joinRateShow = joinRateShow;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }
}
