package com.bxm.adsmanager.integration.datapark.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import com.bxm.adsmanager.integration.utils.DataParkUtils;

/**
 * @Description 开发者日报vo
 * @FileName com.bxm.adsmanager.model.vo.report.AppCount.java
 * @CopyRright (c) 2018-bxm：weicai
 * @Creator qinganquan
 * @Created 2018-02-28 10:52:00
 * @Modifier qinganquan
 * @Updated 2018-02-28 10:52:00
 * @Version BUILD1001
 */
public class AppCount implements java.io.Serializable{


    private static final long serialVersionUID = -2543995742973781996L;
    /**
     * 编号
     */
    private String number;
    /**
     * 日期
     */

    private String datetime;

    /**
     * 开发者唯一标识
     */
    private String appKey;

    /**
     * 开发者唯一标识
     */
    private String business;

    /**
     * 入口点击量
     */

    private Integer iconClickPv;

    /**
     * 入口点击pv环比昨日，已乘100
     */

    private String iconClickChange;

    /**
     * 中间页uv
     */

    private Integer midPageUv;

    /**
     * 中间页uv环比昨日，已乘100
     */

    private String midUvChange;

    /**
     * 中间页pv
     */

    private Integer midPagePv;

    /**
     * 中间页pv环比昨日，已乘100
     */

    private String midPvChange;

    /**
     * 活动首页pv
     */

    private Integer indexPv;

    /**
     * 活动首页pv环比昨日，已乘100
     */

    private String indexPvChange;

    /**
     * 活动首页uv
     */

    private Integer indexUv;

    /**
     * 活动首页uv环比昨日，已乘100
     */

    private String indexUvChange;

    private Integer joinUv;

    private Integer clickPv;

    /**
     * 活动参与率
     */

    private Double joinRate;
    private String joinRateShow;

    /**
     * 活动参与率环比昨日，已乘100
     */

    private String joinRateChange;

    /**
     * 发券请求量
     */

    private Integer sendPv;

    /**
     * 发券请求环比昨日，已乘100
     */

    private String sendPvChange;

    /**
     * 发券量
     */

    private Integer openPv;

    /**
     * 发券量环比昨日，已乘100
     */

    private String openPvChange;

    /**
     * 发券成功率
     */

    private Double successRate;
    private String successRateShow;

    /**
     * 发券成功率环比昨日，已乘100
     */
    private String successRateChange;

    /**
     * 安卓发券占比
     */

    private Double androidOpenRate;
    private String androidOpenRateShow;

    /**
     * 安卓发券占比环比昨日，已乘100
     */

    private String androidRateChange;

    /**
     * ios发券占比
     */

    private Double iosOpenRate;
    private String iosOpenRateShow;

    /**
     * ios发券占比环比昨日，已乘100
     */

    private String iosRateChange;

    /**
     * web发券占比
     */

    private Double webOpenRate;
    private String webOpenRateShow;

    /**
     * web发券占比环比昨日，已乘100
     */

    private String webRateChange;

    /**
     * 微信发券占比
     */

    private Double wechatOpenRate;
    private String wechatOpenRateShow;

    /**
     * 微信发券占比环比昨日，已乘100
     */

    private String wechatRateChange;

    /**
     * IMEI发券占比
     */
    private Double imeiOpenRate;
    private String imeiOpenRateShow;

    /**
     * IMEI发券占比环比昨日，已乘100
     */
    private String imeiRateChange;

    /**
     * 老用户占比（当日uv中在前三天有访问记录的uv记为老用户）
     */
    private Double oldRate;
    private String oldRateShow;

    /**
     * 老用户占比环比昨日，已乘100
     */
    private String oldRateChange;

    /**
     * 广告券点击率
     */
    private Double clickRate;
    private String clickRateShow;

    /**
     * 广告券点击率环比昨日，已乘100
     */
    private String clickRateChange;

    /**
     * 人均发券量
     */
    private Double perOpenPv;

    /**
     * 人均发券环比昨日，已乘100
     */
    private String perOpenPvChange;

    /**
     * 人均重复发券
     */
    private Double rptOpenPv;

    /**
     * 人均重复发券环比昨日，已乘100
     */
    private String rptOpenPvChange;

    /**
     * 券收入
     */
    private Double income;

    /**
     * 券收入涨幅
     */
    private String incomeChange;
    /**
     * 开发者收益
     */
    private Double developerIncome;
    /**
     * 开发者收益涨幅
     */
    private String developerIncomeChange;
    /**
     * 变现猫收益
     */
    private Double bxmIncome;
    /**
     * 变现猫收益涨幅
     */
    private String bxmIncomeChange;
    /**
     * 发券ARUP
     */
    private Double openPvAurp;
    /**
     * 发券ARUP涨幅
     */
    private String openPvAurpChange;
    /**
     * UVARUP
     */
    private Double uvAurp;
    /**
     * UVARUP涨幅
     */
    private String uvAurpChange;
    /**
     * 开发者UVARUP
     */
    private Double developerAurp;
    /**
     * 开发者UVARUP涨幅
     */
    private String developerAurpChange;
    /**
     * 变现猫UVARUP
     */
    private Double bxmAurp;
    /**
     * 变现猫UVARUP涨幅
     */
    private String bxmArupChange;
    /**
     * 子链接收益（排序）
     */
    private Double businessIncome;
    /**
     * 子链接收益
     */
    private String businessIncomeChange;
    /**
     * 子链接 UVAURP
     */
    private Double businessAurp;
    /**
     * 子链接 UVAURP 涨幅
     */
    private String businessAurpChange;

    /**
     * 券收入 UVAURP
     */
    private Double incomeAurp;
    /**
     * 券收入 UVAURP 涨幅
     */

    /**
     * 广告位曝光数
     */
    private int iconPv;

    /**
     * 广告位曝光数涨幅
     */
    private String iconChange;

    /**
     * 点击到达率
     */
    private Double midPageRate;
    private String midPageRateShow;

    /**
     * 点击到达率涨幅
     * */
    private String midPageRateChange;

    /**
     * 首页曝光数
     * */
    private Integer  landingPagePv;

    /**
     * 首页曝光数涨幅
     * */
    private String landingPageChange;

    /**
     * 页面展现率
     * */
    private Double landingPageRate;
    private String landingPageRateShow;

    /**
     * 页面展现率涨幅
     * */
    private double landingRateChange;


    /**
     * ecpm（券收入除以广告位曝光数）
     * */
    private Double ecpm;

    /**
     * ecpm涨幅
     * */
    private String ecpmChange;

    /**
     * mEcpm 媒体ecpm（子链接收益除以广告位曝光数）
     * */
    private Double mEcpm;

    /**
     * mEcpm涨幅
     * */
    private String mEcpmChange;

    /**
     *子链接UVarpu
     * */
    private Double bussinessUvArpu;

    /**
     *券收入UVArpu
     * */
    private Double incomeUvArpu;

    private String incomeAurpChange;

    public Integer getJoinUv() {
        return joinUv;
    }

    public void setJoinUv(Integer joinUv) {
        this.joinUv = joinUv;
    }

    public Integer getClickPv() {
        return clickPv;
    }

    public void setClickPv(Integer clickPv) {
        this.clickPv = clickPv;
    }

    public String getDatetime() {
        return datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public Integer getIconClickPv() {
        return iconClickPv;
    }

    public void setIconClickPv(Integer iconClickPv) {
        this.iconClickPv = iconClickPv;
    }

    public String getIconClickChange() {
        return iconClickChange;
    }

    public void setIconClickChange(String iconClickChange) {
        this.iconClickChange = iconClickChange;
    }

    public Integer getMidPageUv() {
        return midPageUv;
    }

    public void setMidPageUv(Integer midPageUv) {
        this.midPageUv = midPageUv;
    }

    public Integer getMidPagePv() {
        return midPagePv;
    }

    public void setMidPagePv(Integer midPagePv) {
        this.midPagePv = midPagePv;
    }

    public String getMidUvChange() {
        return midUvChange;
    }

    public void setMidUvChange(String midUvChange) {
        this.midUvChange = midUvChange;
    }



    public String getMidPvChange() {
        return midPvChange;
    }

    public void setMidPvChange(String midPvChange) {
        this.midPvChange = midPvChange;
    }

    public Integer getIndexPv() {
        return indexPv;
    }

    public void setIndexPv(Integer indexPv) {
        this.indexPv = indexPv;
    }

    public String getIndexPvChange() {
        return indexPvChange;
    }

    public void setIndexPvChange(String indexPvChange) {
        this.indexPvChange = indexPvChange;
    }

    public Integer getIndexUv() {
        return indexUv;
    }

    public void setIndexUv(Integer indexUv) {
        this.indexUv = indexUv;
    }

    public String getIndexUvChange() {
        return indexUvChange;
    }

    public void setIndexUvChange(String indexUvChange) {
        this.indexUvChange = indexUvChange;
    }

    public Double getJoinRate() {
        return joinRate;
    }

    public void setJoinRate(Double joinRate) {
        this.joinRate = joinRate;
    }

    public String getJoinRateChange() {
        return joinRateChange;
    }

    public void setJoinRateChange(String joinRateChange) {
        this.joinRateChange = joinRateChange;
    }

    public Integer getSendPv() {
        return sendPv;
    }

    public void setSendPv(Integer sendPv) {
        this.sendPv = sendPv;
    }

    public String getSendPvChange() {
        return sendPvChange;
    }

    public void setSendPvChange(String sendPvChange) {
        this.sendPvChange = sendPvChange;
    }

    public Integer getOpenPv() {
        return openPv;
    }

    public void setOpenPv(Integer openPv) {
        this.openPv = openPv;
    }

    public String getOpenPvChange() {
        return openPvChange;
    }

    public void setOpenPvChange(String openPvChange) {
        this.openPvChange = openPvChange;
    }

    public Double getSuccessRate() {
        return successRate;
    }

    public void setSuccessRate(Double successRate) {
        this.successRate = successRate;
    }

    public String getSuccessRateChange() {
        return successRateChange;
    }

    public void setSuccessRateChange(String successRateChange) {
        this.successRateChange = successRateChange;
    }

    public Double getAndroidOpenRate() {
        return androidOpenRate;
    }

    public void setAndroidOpenRate(Double androidOpenRate) {
        this.androidOpenRate = androidOpenRate;
    }

    public String getAndroidRateChange() {
        return androidRateChange;
    }

    public void setAndroidRateChange(String androidRateChange) {
        this.androidRateChange = androidRateChange;
    }

    public Double getIosOpenRate() {
        return iosOpenRate;
    }

    public void setIosOpenRate(Double iosOpenRate) {
        this.iosOpenRate = iosOpenRate;
    }

    public String getIosRateChange() {
        return iosRateChange;
    }

    public void setIosRateChange(String iosRateChange) {
        this.iosRateChange = iosRateChange;
    }

    public Double getWebOpenRate() {
        return webOpenRate;
    }

    public void setWebOpenRate(Double webOpenRate) {
        this.webOpenRate = webOpenRate;
    }

    public String getWebRateChange() {
        return webRateChange;
    }

    public void setWebRateChange(String webRateChange) {
        this.webRateChange = webRateChange;
    }

    public Double getWechatOpenRate() {
        return wechatOpenRate;
    }

    public void setWechatOpenRate(Double wechatOpenRate) {
        this.wechatOpenRate = wechatOpenRate;
    }

    public String getWechatRateChange() {
        return wechatRateChange;
    }

    public void setWechatRateChange(String wechatRateChange) {
        this.wechatRateChange = wechatRateChange;
    }

    public Double getImeiOpenRate() {
        return imeiOpenRate;
    }

    public void setImeiOpenRate(Double imeiOpenRate) {
        this.imeiOpenRate = imeiOpenRate;
    }

    public String getImeiRateChange() {
        return imeiRateChange;
    }

    public void setImeiRateChange(String imeiRateChange) {
        this.imeiRateChange = imeiRateChange;
    }

    public Double getOldRate() {
        return oldRate;
    }

    public void setOldRate(Double oldRate) {
        this.oldRate = oldRate;
    }

    public String getOldRateChange() {
        return oldRateChange;
    }

    public void setOldRateChange(String oldRateChange) {
        this.oldRateChange = oldRateChange;
    }

    public Double getClickRate() {
        return clickRate;
    }

    public void setClickRate(Double clickRate) {
        this.clickRate = clickRate;
    }

    public String getClickRateChange() {
        return clickRateChange;
    }

    public void setClickRateChange(String clickRateChange) {
        this.clickRateChange = clickRateChange;
    }

    public Double getPerOpenPv() {
        return perOpenPv;
    }

    public void setPerOpenPv(Double perOpenPv) {
        this.perOpenPv = perOpenPv;
    }

    public String getPerOpenPvChange() {
        return perOpenPvChange;
    }

    public void setPerOpenPvChange(String perOpenPvChange) {
        this.perOpenPvChange = perOpenPvChange;
    }

    public Double getRptOpenPv() {
        return rptOpenPv;
    }

    public void setRptOpenPv(Double rptOpenPv) {
        this.rptOpenPv = rptOpenPv;
    }

    public String getRptOpenPvChange() {
        return rptOpenPvChange;
    }

    public void setRptOpenPvChange(String rptOpenPvChange) {
        this.rptOpenPvChange = rptOpenPvChange;
    }

    public String getSuccessRateShow() {
        return DataParkUtils.getPercent(successRate);
    }

    public void setSuccessRateShow(String successRateShow) {
        this.successRateShow = successRateShow;
    }

    public String getAndroidOpenRateShow() {
        return DataParkUtils.getPercent(androidOpenRate);
    }

    public void setAndroidOpenRateShow(String androidOpenRateShow) {
        this.androidOpenRateShow = androidOpenRateShow;
    }

    public String getIosOpenRateShow() {
        return DataParkUtils.getPercent(iosOpenRate);
    }

    public void setIosOpenRateShow(String iosOpenRateShow) {
        this.iosOpenRateShow = iosOpenRateShow;
    }

    public String getWebOpenRateShow() {
        return DataParkUtils.getPercent(webOpenRate);
    }

    public void setWebOpenRateShow(String webOpenRateShow) {
        this.webOpenRateShow = webOpenRateShow;
    }

    public String getWechatOpenRateShow() {
        return DataParkUtils.getPercent(wechatOpenRate);
    }

    public void setWechatOpenRateShow(String wechatOpenRateShow) {
        this.wechatOpenRateShow = wechatOpenRateShow;
    }

    public String getImeiOpenRateShow() {
        return DataParkUtils.getPercent(imeiOpenRate);
    }

    public void setImeiOpenRateShow(String imeiOpenRateShow) {
        this.imeiOpenRateShow = imeiOpenRateShow;
    }

    public String getOldRateShow() {
        return DataParkUtils.getPercent(oldRate);
    }

    public void setOldRateShow(String oldRateShow) {
        this.oldRateShow = oldRateShow;
    }

    public String getClickRateShow() {
        return DataParkUtils.getPercent(clickRate);
    }

    public void setClickRateShow(String clickRateShow) {
        this.clickRateShow = clickRateShow;
    }

    public String getJoinRateShow() {
        return DataParkUtils.getPercent(joinRate);
    }

    public void setJoinRateShow(String joinRateShow) {
        this.joinRateShow = joinRateShow;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Double getIncome() {
        return income;
    }

    public String getIncomeChange() {
        return incomeChange;
    }

    public Double getDeveloperIncome() {
        return developerIncome;
    }

    public String getDeveloperIncomeChange() {
        return developerIncomeChange;
    }

    public Double getBxmIncome() {
        return bxmIncome;
    }

    public String getBxmIncomeChange() {
        return bxmIncomeChange;
    }

    public Double getOpenPvAurp() {
        return openPvAurp;
    }

    public String getOpenPvAurpChange() {
        return openPvAurpChange;
    }

    public Double getUvAurp() {
        return uvAurp;
    }

    public String getUvAurpChange() {
        return uvAurpChange;
    }

    public Double getDeveloperAurp() {
        return developerAurp;
    }

    public String getDeveloperAurpChange() {
        return developerAurpChange;
    }

    public Double getBxmAurp() {
        return bxmAurp;
    }

    public String getBxmArupChange() {
        return bxmArupChange;
    }

    public Double getBusinessIncome() {
        return businessIncome;
    }

    public String getBusinessIncomeChange() {
        return businessIncomeChange;
    }

    public Double getBusinessAurp() {
        return businessAurp;
    }

    public String getBusinessAurpChange() {
        return businessAurpChange;
    }

    public void setIncome(Double income) {
        this.income = income;
    }

    public void setIncomeChange(String incomeChange) {
        this.incomeChange = incomeChange;
    }

    public void setDeveloperIncome(Double developerIncome) {
        this.developerIncome = developerIncome;
    }

    public void setDeveloperIncomeChange(String developerIncomeChange) {
        this.developerIncomeChange = developerIncomeChange;
    }

    public void setBxmIncome(Double bxmIncome) {
        this.bxmIncome = bxmIncome;
    }

    public void setBxmIncomeChange(String bxmIncomeChange) {
        this.bxmIncomeChange = bxmIncomeChange;
    }

    public void setOpenPvAurp(Double openPvAurp) {
        this.openPvAurp = openPvAurp;
    }

    public void setOpenPvAurpChange(String openPvAurpChange) {
        this.openPvAurpChange = openPvAurpChange;
    }

    public void setUvAurp(Double uvAurp) {
        this.uvAurp = uvAurp;
    }

    public void setUvAurpChange(String uvAurpChange) {
        this.uvAurpChange = uvAurpChange;
    }

    public void setDeveloperAurp(Double developerAurp) {
        this.developerAurp = developerAurp;
    }

    public void setDeveloperAurpChange(String developerAurpChange) {
        this.developerAurpChange = developerAurpChange;
    }

    public void setBxmAurp(Double bxmAurp) {
        this.bxmAurp = bxmAurp;
    }

    public void setBxmArupChange(String bxmArupChange) {
        this.bxmArupChange = bxmArupChange;
    }

    public void setBusinessIncome(Double businessIncome) {
        this.businessIncome = businessIncome;
    }

    public void setBusinessIncomeChange(String businessIncomeChange) {
        this.businessIncomeChange = businessIncomeChange;
    }

    public void setBusinessAurp(Double businessAurp) {
        this.businessAurp = businessAurp;
    }

    public void setBusinessAurpChange(String businessAurpChange) {
        this.businessAurpChange = businessAurpChange;
    }

    public Double getIncomeAurp() {
        return incomeAurp;
    }

    public void setIncomeAurp(Double incomeAurp) {
        this.incomeAurp = incomeAurp;
    }

    public String getIncomeAurpChange() {
        return incomeAurpChange;
    }

    public void setIncomeAurpChange(String incomeAurpChange) {
        this.incomeAurpChange = incomeAurpChange;
    }

    public int getIconPv() {
        return iconPv;
    }

    public void setIconPv(int iconPv) {
        this.iconPv = iconPv;
    }

    public String getIconChange() {
        return iconChange;
    }

    public void setIconChange(String iconChange) {
        this.iconChange = iconChange;
    }

    public Double getMidPageRate() {
        return midPageRate;
    }

    public void setMidPageRate(Double midPageRate) {
        this.midPageRate = midPageRate;
    }

    public String getMidPageRateChange() {
        return midPageRateChange;
    }

    public void setMidPageRateChange(String midPageRateChange) {
        this.midPageRateChange = midPageRateChange;
    }

    public Integer getLandingPagePv() {
        return landingPagePv;
    }

    public void setLandingPagePv(Integer landingPagePv) {
        this.landingPagePv = landingPagePv;
    }

    public String getLandingPageChange() {
        return landingPageChange;
    }

    public void setLandingPageChange(String landingPageChange) {
        this.landingPageChange = landingPageChange;
    }

    public Double getLandingPageRate() {
        return landingPageRate;
    }

    public void setLandingPageRate(Double landingPageRate) {
        this.landingPageRate = landingPageRate;
    }

    public double getLandingRateChange() {
        return landingRateChange;
    }

    public void setLandingRateChange(double landingRateChange) {
        this.landingRateChange = landingRateChange;
    }

    public Double getEcpm() {
        return ecpm;
    }

    public void setEcpm(Double ecpm) {
        this.ecpm = ecpm;
    }

    public String getEcpmChange() {
        return ecpmChange;
    }

    public void setEcpmChange(String ecpmChange) {
        this.ecpmChange = ecpmChange;
    }

    public Double getmEcpm() {
        return mEcpm;
    }

    public void setmEcpm(Double mEcpm) {
        this.mEcpm = mEcpm;
    }

    public String getmEcpmChange() {
        return mEcpmChange;
    }

    public void setmEcpmChange(String mEcpmChange) {
        this.mEcpmChange = mEcpmChange;
    }

    public Double getBussinessUvArpu() {
        return bussinessUvArpu;
    }

    public void setBussinessUvArpu(Double bussinessUvArpu) {
        this.bussinessUvArpu = bussinessUvArpu;
    }

    public Double getIncomeUvArpu() {
        return incomeUvArpu;
    }

    public void setIncomeUvArpu(Double incomeUvArpu) {
        this.incomeUvArpu = incomeUvArpu;
    }

    public String getMidPageRateShow() {
        return DataParkUtils.getPercent(midPageRate);
    }

    public void setMidPageRateShow(String midPageRateShow) {
        this.midPageRateShow = midPageRateShow;
    }

    public String getLandingPageRateShow() {
        return DataParkUtils.getPercent(landingPageRate);
    }

    public void setLandingPageRateShow(String landingPageRateShow) {
        this.landingPageRateShow = landingPageRateShow;
    }
}
