/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with http://www.bianxianmao.com.
 */

package com.bxm.adsmanager.integration.datapark.model;

import java.io.Serializable;

import org.apache.commons.lang3.StringUtils;

import com.bxm.adsmanager.integration.utils.DataParkUtils;
import com.bxm.commons.currency.Money;

import cn.afterturn.easypoi.excel.annotation.Excel;

/**
 *
 * 广告券日报
 *
 * @author 董朱旭
 * @version BUILD1001
 * @fileName com.bxm.datapark.dal.mongo.vo.TicketCountCommon.java
 * @CopyRright (c) 2017-bxm：杭州微财科技有限公司
 * @created 2018-01-06 16:36:00
 * @modifier 董朱旭
 * @updated 2018-01-06 16:36:00
 * @description
 */
public class TicketCountCommon implements Serializable{


    /**
     * 日期
     */

    private String datetime;


    /**
     * 券id
     */
    private Long certificateid;

    /**
     * appkey
     */

    private String appkey;

    /**
     * 子渠道标志
     */

    private String business;

    /**
     * 发券请求
     */

    private Integer sendPv;
    /**
     * 发券请求涨幅
     */

    private String sendPvChange;
    /**
     * 点击量
     */

    @Excel(name = "点击量")
    private Integer clickPv;
    /**
     * 点击量涨幅
     */

    @Excel(name = "点击量涨幅")
    private String clickPvChange;

    /**
     * 曝光量（发券量）
     */
    @Excel(name = "发券量")
    private Integer openPv;
    /**
     * 曝光量（发券量）涨幅
     */
    @Excel(name = "发券量涨幅")
    private String openPvChange;

    /**
     * 有效点击量
     */
    @Excel(name = "有效点击量")
    private Integer validClick;

    /**
     * 有效点击量涨幅
     */

    @Excel(name = "有效点击量涨幅")
    private String validClickChange;


    /**
     * 有效点击率
     */
    @Excel(name = "有效点击率")
    private Double validClickRate;
    private String validClickRateShow;


    /**
     * 有效点击率涨幅
     */
    @Excel(name = "有效点击率涨幅")
    private String validClickRateChange;

    /**
     * 转化率
     */
    @Excel(name = "转化率")
    private Double conversion;
    private String conversionShow;

    /**
     * 转化率涨幅
     */
    @Excel(name = "转化率涨幅")
    private String conversionChange;

    /**
     * 券收入
     */
    private Double income;
    /**
     * 券收入涨幅
     */
    private String incomeChange;


    /**
     * 发券aurp
     */
    private Double openPvAurp;
    /**
     * 发券aurp涨幅
     */
    private String openPvAurpChange;
    /**
     * 点击aurp
     */
    private Double clickAurp;
    /**
     * 点击aurp涨幅
     */
    private String clickAurpChange;

    /**
     * 有效点击率占比
     */
    private Double qualityFactor;

    private String qualityFactorShow;

    /**
     * 有效点击率占比涨幅
     */
    private String qualityFactorChange;

    /**
     * 发券占比
     */
    @Excel(name = "发券占比")
    private String openPvRateShow;
    private Double openPvRate;

    /**
     * 发券占比涨幅
     */
    @Excel(name = "发券占比涨幅")
    private String openPvRateChange;

    /**
     * 时间段
     */
    @Excel(name = "时间段")
    private Integer hours;

    /**
     *
     */
    @Excel(name = "编号")
    private String number;
    
    private String positionId;
    
    private Long consume;
    
    public Long getConsume() {
		return consume != null ? consume : 0L;
	}

	public void setConsume(Long consume) {
		this.consume = consume;
	}

	public String getPositionId() {
    	if (StringUtils.isNotEmpty(business)) {
    		positionId = appkey + "-" + business.replace("ad-", "");
		}
		return positionId;
	}

	public void setPositionId(String positionId) {
		this.positionId = positionId;
	}

	public String getDatetime() {
        return datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public Long getCertificateid() {
        return certificateid;
    }

    public void setCertificateid(Long certificateid) {
        this.certificateid = certificateid;
    }

    public String getAppkey() {
        return appkey;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public Integer getSendPv() {
        return sendPv;
    }

    public void setSendPv(Integer sendPv) {
        this.sendPv = sendPv;
    }

    public String getSendPvChange() {
        return sendPvChange;
    }

    public void setSendPvChange(String sendPvChange) {
        this.sendPvChange = sendPvChange;
    }

    public Integer getClickPv() {
        return clickPv;
    }

    public void setClickPv(Integer clickPv) {
        this.clickPv = clickPv;
    }

    public String getClickPvChange() {
        return clickPvChange;
    }

    public void setClickPvChange(String clickPvChange) {
        this.clickPvChange = clickPvChange;
    }

    public Integer getOpenPv() {
        return openPv;
    }

    public void setOpenPv(Integer openPv) {
        this.openPv = openPv;
    }

    public String getOpenPvChange() {
        return openPvChange;
    }

    public void setOpenPvChange(String openPvChange) {
        this.openPvChange = openPvChange;
    }

    public Integer getValidClick() {
        return validClick;
    }

    public void setValidClick(Integer validClick) {
        this.validClick = validClick;
    }

    public String getValidClickChange() {
        return validClickChange;
    }

    public void setValidClickChange(String validClickChange) {
        this.validClickChange = validClickChange;
    }

    public Double getValidClickRate() {
        return validClickRate;
    }

    public void setValidClickRate(Double validClickRate) {
        this.validClickRate = validClickRate;
    }

    public String getValidClickRateChange() {
        return validClickRateChange;
    }

    public void setValidClickRateChange(String validClickRateChange) {
        this.validClickRateChange = validClickRateChange;
    }

    public Double getConversion() {
        return conversion;
    }

    public void setConversion(Double conversion) {
        this.conversion = conversion;
    }

    public String getConversionChange() {
        return conversionChange;
    }

    public void setConversionChange(String conversionChange) {
        this.conversionChange = conversionChange;
    }

    public Double getIncome() {
        return income;
    }

    public void setIncome(Double income) {
        this.income = income;
    }

    public String getIncomeChange() {
        return incomeChange;
    }

    public void setIncomeChange(String incomeChange) {
        this.incomeChange = incomeChange;
    }

    public Double getOpenPvAurp() {
        return openPvAurp;
    }

    public void setOpenPvAurp(Double openPvAurp) {
        this.openPvAurp = openPvAurp;
    }

    public String getOpenPvAurpChange() {
        return openPvAurpChange;
    }

    public void setOpenPvAurpChange(String openPvAurpChange) {
        this.openPvAurpChange = openPvAurpChange;
    }

    public Double getClickAurp() {
        return clickAurp;
    }

    public void setClickAurp(Double clickAurp) {
        this.clickAurp = clickAurp;
    }

    public String getClickAurpChange() {
        return clickAurpChange;
    }

    public void setClickAurpChange(String clickAurpChange) {
        this.clickAurpChange = clickAurpChange;
    }

    public Double getQualityFactor() {
        return qualityFactor;
    }

    public void setQualityFactor(Double qualityFactor) {
        this.qualityFactor = qualityFactor;
    }

    public String getQualityFactorChange() {
        return qualityFactorChange;
    }

    public void setQualityFactorChange(String qualityFactorChange) {
        this.qualityFactorChange = qualityFactorChange;
    }

    public Double getOpenPvRate() {
        return openPvRate;
    }

    public void setOpenPvRate(Double openPvRate) {
        this.openPvRate = openPvRate;
    }

    public String getOpenPvRateChange() {
        return openPvRateChange;
    }

    public void setOpenPvRateChange(String openPvRateChange) {
        this.openPvRateChange = openPvRateChange;
    }

    public Integer getHours() {
        return hours;
    }

    public void setHours(Integer hours) {
        this.hours = hours;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getValidClickRateShow() {
        return DataParkUtils.getPercent(validClickRate);
    }

    public void setValidClickRateShow(String validClickRateShow) {
        this.validClickRateShow = validClickRateShow;
    }

    public String getConversionShow() {
        return DataParkUtils.getPercent(conversion);
    }

    public void setConversionShow(String conversionShow) {
        this.conversionShow = conversionShow;
    }

    public String getOpenPvRateShow() {
        return DataParkUtils.getPercent(openPvRate);
    }

    public void setOpenPvRateShow(String openPvRateShow) {
        this.openPvRateShow = openPvRateShow;
    }

    public String getQualityFactorShow() {
        return DataParkUtils.getQualityFactorShow(qualityFactor);
    }

    /*public String getQualityFactorShow() {
        return qualityFactor+"";
    }*/

    public void setQualityFactorShow(String qualityFactorShow) {
        this.qualityFactorShow = qualityFactorShow;
    }
}
