package com.bxm.adsmanager.integration.datapark.service;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.integration.advertiser.model.Pagination;
import com.bxm.adsmanager.integration.datapark.model.ActivityCount;
import com.bxm.adsmanager.integration.datapark.model.Page;
import com.bxm.adsmanager.integration.resttemplate.RestTemplateClient;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 调用datapark活动报表
 *
 * @author zhangkai
 * @create 2018-02-27 16:25
 **/
@Configuration
@Component
public class DataparkActivityPullerIntegration {

    @Value("${datapark.url}")
    private String DATAPARKURL ;
    @Autowired
    private RestTemplateClient restTemplateClient;

    private static final Logger logger = Logger.getLogger(DataparkActivityPullerIntegration.class);

    /*
     * 分页查询活动报表
     * @author zhangkai
     * @date 2018/2/27 18:01
     * @param
     * @return
     */
    public ResultModel pullActivityData(String datetime, String json, Integer pageSize, Integer pageNum, String sortName, String sortType){
        Map<String,Object> parm = new HashMap<>();
        ResultModel<Pagination> resultModel = new ResultModel<>();
        if (!StringUtil.isEmpty(datetime)){
            parm.put("datetime",datetime);
        }
        if (!StringUtil.isEmpty(json)){
            parm.put("json",json);
        }
        if (pageSize != null){
            parm.put("pageSize",String.valueOf(pageSize));
        }
        if (pageNum != null){
            parm.put("pageNum",String.valueOf(pageNum));
        }
        if (!StringUtil.isEmpty(sortName)){
            parm.put("sortName",sortName);
        }
        if (!StringUtil.isEmpty(sortType)){
            parm.put("sortType",sortType);
        }
        resultModel = pullData(resultModel,"/activity",parm);
        return resultModel;
    }

    /*  
     * 导出活动报表
     * @author zhangkai  
     * @date 2018/2/28 11:05  
     * @param   
     * @return   
     */ 
    public List<ActivityCount>  activityReportExport(String datetime,String json){
        Map<String,Object> parm = new HashMap<>();
        parm.put("datetime",datetime);
        if (!StringUtils.isEmpty(json)){
            parm.put("json",json);
        }
        return pullExportData("/activity/export",parm);
    }


    /*  
     * 分页查询活动报表按开发者维度
     * @author zhangkai  
     * @date 2018/2/28 11:31
     * @param   
     * @return   
     */ 
    public ResultModel  activityReportApp(String datetime,String json,Long activityId,Integer pageSize,Integer pageNum,String sortName,String sortType){
        ResultModel<Pagination> resultModel = new ResultModel<>();
        Map<String,Object> parm = new HashMap<>();
        parm.put("datetime",datetime);
        parm.put("activityId",activityId);
        if (!StringUtil.isEmpty(datetime)){
            parm.put("datetime",datetime);
        }
        if (!StringUtil.isEmpty(json)){
            parm.put("json",json);
        }
        if (pageSize != null){
            parm.put("pageSize",String.valueOf(pageSize));
        }
        if (pageNum != null){
            parm.put("pageNum",String.valueOf(pageNum));
        }
        if (!StringUtil.isEmpty(sortName)){
            parm.put("sortName",sortName);
        }
        if (!StringUtil.isEmpty(sortType)){
            parm.put("sortType",sortType);
        }
        resultModel = pullData(resultModel,"/activity/app",parm);
        return resultModel;
    }




    /*
     * 导出活动报表开发者维度
     * @author zhangkai
     * @date 2018/2/28 11:52
     * @param
     * @return
     */
    public List<ActivityCount>  activityReportAppExport(String datetime,String json,Long activityId){
        Map<String,Object> parm = new HashMap<>();
        parm.put("datetime",datetime);
        parm.put("activityId",activityId);
        if (!StringUtil.isEmpty(json)){
            parm.put("json",json);
        }
        return pullExportData("/activity/app/export",parm);
    }




    /*
     * 活动报表开发者子链接维度
     * @author zhangkai
     * @date 2018/2/28 14:23
     * @param
     * @return
     */
    public ResultModel  activityReportAppBusiness(String datetime,String json,Long activityId,String appKey,Integer pageSize,Integer pageNum,String sortName,String sortType){
        ResultModel<Pagination> resultModel = new ResultModel<>();
        Map<String,Object> parm = new HashMap<>();
        parm.put("datetime",datetime);
        parm.put("activityId",activityId);
        parm.put("appkey",appKey);
        if (!StringUtil.isEmpty(datetime)){
            parm.put("datetime",datetime);
        }
        if (!StringUtil.isEmpty(json)){
            parm.put("json",json);
        }
        if (pageSize != null){
            parm.put("pageSize",String.valueOf(pageSize));
        }
        if (pageNum != null){
            parm.put("pageNum",String.valueOf(pageNum));
        }
        if (!StringUtil.isEmpty(sortName)){
            parm.put("sortName",sortName);
        }
        if (!StringUtil.isEmpty(sortType)){
            parm.put("sortType",sortType);
        }
        resultModel = pullData(resultModel,"/activity/business",parm);
        return resultModel;
    }


    /*
     * 调用Datapark服务接口
     * @author zhangkai
     * @date 2018/2/28 14:35
     * @param
     * @return
     */
    public ResultModel pullData(ResultModel<Pagination> resultModel,String url,Map<String,Object> parm) {
        try {
            //调用datapark活动接口
            String result = restTemplateClient.getByParams(DATAPARKURL + url, parm, HttpMethod.POST, null);
            Page<ActivityCount> page = JSON.parseObject(JSON.parseObject(result).get("returnValue").toString(),
                    Page.class);
            if (page.getList() == null) {
                resultModel.setReturnValue(null);
                return resultModel;
            }
            if (page.getSize() > 0) {
                List<ActivityCount> list = JSON.parseArray(page.getList().toString(), ActivityCount.class);
                page.setList(list);
            }
            Pagination pagination = new Pagination(page.getPageNum(), page.getSize(), page.getTotal().intValue(), page.getList());
            resultModel.setReturnValue(pagination);
            return resultModel;
        } catch (Exception e) {
            logger.error("调用datapark活动报表接口失败url:+"+url+e.getMessage(),e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("调用datapark活动报表接口失败");
        }
        return resultModel;
    }



    /*  
     * 导出活动报表开发者子链接维度
     * @author zhangkai  
     * @date 2018/2/28 14:40
     * @param   
     * @return   
     */ 
    public List<ActivityCount>  activityReportAppBusinessExport(String datetime,String json,Long activityId,String appKey){
        Map<String,Object> parm = new HashMap<>();
        parm.put("datetime",datetime);
        parm.put("activityId",activityId);
        parm.put("appkey",appKey);
        if (!StringUtil.isEmpty(json)){
            parm.put("json",json);
        }
        return  pullExportData("/activity/business/export",parm);
    }


    /*
     * 调用Datapark服务导出接口
     * @author zhangkai
     * @date 2018/2/28 14:44
     * @param
     * @return
     */
    public List<ActivityCount> pullExportData(String url,Map<String,Object> parm){
        List<ActivityCount> activityCounts = Lists.newArrayList();
        try {
            //调用datapark活动接口
            String result = restTemplateClient.getByParams(DATAPARKURL + url, parm, HttpMethod.POST, null);

            activityCounts = JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), ActivityCount.class);
            return activityCounts;
        } catch (Exception e) {
            logger.error("调用datapark活动报表开发者维度导出接口失败"+e.getMessage(),e);
        }
        return activityCounts;
    }



    /*  
     * 活动报表按日
     * @author zhangkai  
     * @date 2018/2/28 15:01  
     * @param   
     * @return   
     */ 
    public List<ActivityCount> activityReportByDate(String startTime,String endTime,Long activityId,String sortName,String sortType){
        List<ActivityCount> activityCounts = Lists.newArrayList();
        Map<String,Object> parm = new HashMap<>();
        parm.put("startTime",startTime);
        parm.put("endTime",endTime);
        if (activityId != null){
            parm.put("activityId",activityId);
        }
        if (!StringUtil.isEmpty(sortName)){
            parm.put("sortName",sortName);
        }
        if (!StringUtil.isEmpty(sortType)){
            parm.put("sortType",sortType);
        }
        String result = null;
        try {
            result = restTemplateClient.getByParams(DATAPARKURL + "/activity/date", parm, HttpMethod.POST, null);
            activityCounts = JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), ActivityCount.class);
        } catch (Exception e) {
            logger.error("调用datapark活动报表接口失败"+e.getMessage(),e);
        }
        return activityCounts;
    }



    /*
     * 活动报表子链接按日
     * @author zhangkai
     * @date 2018/2/28 15:24
     * @param
     * @return
     */
    public List<ActivityCount> activityReportBusinessByDate(String startTime,String endTime,Long activityId,String appKey,String business,String sortName,String sortType){
        List<ActivityCount> activityCounts = Lists.newArrayList();
        Map<String,Object> parm = new HashMap<>();
        parm.put("startTime",startTime);
        parm.put("endTime",endTime);
        if (activityId != null){
            parm.put("activityId",activityId);
        }
        if (!StringUtil.isEmpty(sortName)){
            parm.put("sortName",sortName);
        }
        if (!StringUtil.isEmpty(sortType)){
            parm.put("sortType",sortType);
        }
        if (!StringUtil.isEmpty(appKey)){
            parm.put("appkey",appKey);
        }
        if (!StringUtil.isEmpty(business)){
            parm.put("business",business);
        }
        String result = null;
        try {
            result = restTemplateClient.getByParams(DATAPARKURL + "/activity/business/date", parm, HttpMethod.POST, null);
            activityCounts = JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), ActivityCount.class);
        } catch (Exception e) {
            logger.error("调用datapark活动报表接口失败"+e.getMessage(),e);
        }
        return activityCounts;
    }
}
