package com.bxm.adsmanager.integration.datapark.service;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.integration.advertiser.model.Pagination;
import com.bxm.adsmanager.integration.datapark.model.ActivityCount;
import com.bxm.adsmanager.integration.datapark.model.AppCount;
import com.bxm.adsmanager.integration.datapark.model.Page;
import com.bxm.adsmanager.integration.datapark.model.TicketCountCommon;
import com.bxm.adsmanager.integration.resttemplate.RestTemplateClient;
import com.bxm.util.dto.ResultModel;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 调用datapark开发者报表
 * @author ganquan
 * @version v1.1.4_Report
 * @fileName com.bxm.adsmanager.integration.datapark.service.DataparkAppPullerIntegration.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2018-03-01 11:53:00
 * @modifier ganquan
 * @updated 2018-03-01 11:53:00
 */
@Configuration
@Component
public class DataparkAppPullerIntegration {

    @Autowired
    private RestTemplateClient restTemplateClient;
    @Value("${datapark.url}")
    private String DATAPARKURL ;
    /**
     * 调用datapark，分页查询开发者日报
     * @param datetime
     * @param pageSize
     * @param pageNum
     * @param sortName
     * @param sortType
     * @param appKeysJson
     * @return
     * @throws IOException
     */
    public Page<AppCount> getAppCountPage(String datetime, Integer pageSize, Integer pageNum, String sortName, String sortType, String appKeysJson) throws IOException {
        //1、封装条件
        Map<String,Object> maps = Maps.newHashMap();
        if (StringUtils.isNotEmpty(datetime)){
            maps.put("datetime",datetime);
        }
        if (pageSize!=null){
            maps.put("pageSize",pageSize);
        }
        if (pageNum!=null){
            maps.put("pageNum",pageNum);
        }
        if (StringUtils.isNotEmpty(sortName)){
            maps.put("sortName",sortName);
        }
        if (StringUtils.isNotEmpty(sortType)){
            maps.put("sortType",sortType);
        }
        if (StringUtils.isNotEmpty(appKeysJson)){
            maps.put("json",appKeysJson);
        }
        //2、调用datapark接口
        String result = restTemplateClient.getByParams(DATAPARKURL+"/app/getAppCount", maps, HttpMethod.POST, null);
        if (JSON.parseObject(result).get("returnValue")==null){
            return new Page<AppCount>();
        }
        //3、解析结果集
        Page page = JSON.parseObject(JSON.parseObject(result).get("returnValue").toString(), Page.class);
        if (CollectionUtils.isNotEmpty(page.getList())) {
            List<AppCount> list = JSON.parseArray(page.getList().toString(), AppCount.class);
            page.setList(list);
        }
        return page;
    }

    /**
     * 调用datapark查询开发者日报不分页
     * @param datetime
     * @param sortName
     * @param sortType
     * @param appKeysJson
     * @return
     * @throws IOException
     */
    public List<AppCount> getAppCountVos(String datetime, String sortName, String sortType, String appKeysJson) throws IOException {
        //1、封装条件
        Map<String,Object> maps = Maps.newHashMap();
        if (StringUtils.isNotEmpty(datetime)){
            maps.put("datetime",datetime);
        }
        if (StringUtils.isNotEmpty(sortName)){
            maps.put("sortName",sortName);
        }
        if (StringUtils.isNotEmpty(sortType)){
            maps.put("sortType",sortType);
        }
        if (StringUtils.isNotEmpty(appKeysJson)){
            maps.put("json",appKeysJson);
        }
        //2、调用datapark接口
        String result = restTemplateClient.getByParams(DATAPARKURL+"/app/export", maps, HttpMethod.POST, null);
        if (JSON.parseObject(result).get("returnValue")==null){
            return new ArrayList<AppCount>();
        }
        //3、解析结果集
        List<AppCount> list = JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), AppCount.class);
        if (CollectionUtils.isEmpty(list)){
            new ArrayList<AppCount>();
        }
        return list;
    }

    /**
     * 调用datapark分页查询开发者子链接
     * @param datetime
     * @param appKey
     * @param pageSize
     * @param pageNum
     * @param sortName
     * @param sortType
     * @param appBusinessesJson
     * @return
     * @throws IOException
     */
    public Page<AppCount> getAppBusinessCountVoPage(String datetime, String appKey, Integer pageSize, Integer pageNum, String sortName, String sortType, String appBusinessesJson) throws IOException {
        //1、封装条件
        Map<String,Object> maps = Maps.newHashMap();
        if (StringUtils.isNotEmpty(datetime)){
            maps.put("datetime",datetime);
        }
        if (StringUtils.isNotEmpty(appKey)){
            maps.put("appKey",appKey);
        }
        if (pageSize!=null){
            maps.put("pageSize",pageSize);
        }
        if (pageNum!=null){
            maps.put("pageNum",pageNum);
        }
        if (StringUtils.isNotEmpty(sortName)){
            maps.put("sortName",sortName);
        }
        if (StringUtils.isNotEmpty(sortType)){
            maps.put("sortType",sortType);
        }
        if (StringUtils.isNotEmpty(appBusinessesJson)){
            maps.put("json",appBusinessesJson);
        }
        //2、调用datapark接口
        String result = restTemplateClient.getByParams(DATAPARKURL+"/app/business", maps, HttpMethod.POST, null);
        if (JSON.parseObject(result).get("returnValue")==null){
            return new Page<AppCount>();
        }
        //3、解析结果集
        Page page = JSON.parseObject(JSON.parseObject(result).get("returnValue").toString(), Page.class);
        if (CollectionUtils.isNotEmpty(page.getList())) {
            List<AppCount> list = JSON.parseArray(page.getList().toString(), AppCount.class);
            page.setList(list);
        }
        return page;
    }

    /**
     * 调用datapark查询开发者子链接不分页
     * @param datetime
     * @param appKey
     * @param sortName
     * @param sortType
     * @param appBusinessesJson
     * @return
     * @throws IOException
     */
    public List<AppCount> getAppBusinessCountVos(String datetime, String appKey, String sortName, String sortType, String appBusinessesJson) throws IOException {
        //1、封装条件
        Map<String,Object> maps = Maps.newHashMap();
        if (StringUtils.isNotEmpty(datetime)){
            maps.put("datetime",datetime);
        }
        if (StringUtils.isNotEmpty(appKey)){
            maps.put("appKey",appKey);
        }
        if (StringUtils.isNotEmpty(sortName)){
            maps.put("sortName",sortName);
        }
        if (StringUtils.isNotEmpty(sortType)){
            maps.put("sortType",sortType);
        }
        if (StringUtils.isNotEmpty(appBusinessesJson)){
            maps.put("json",appBusinessesJson);
        }
        //2、调用datapark接口
        String result = restTemplateClient.getByParams(DATAPARKURL+"/app/business/export", maps, HttpMethod.POST, null);
        if (JSON.parseObject(result).get("returnValue")==null){
            return new ArrayList<AppCount>();
        }
        //3、解析结果集
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), AppCount.class);
    }

    public List<AppCount> getAppBusinessCountVosBydatime(String datetime) throws IOException {
        //1、封装条件
        Map<String,Object> maps = Maps.newHashMap();
        if (StringUtils.isNotEmpty(datetime)){
            maps.put("datetime",datetime);
        }
        //2、调用datapark接口
        String result = restTemplateClient.getByParams(DATAPARKURL+"/app/business/profit", maps, HttpMethod.POST, null);
        if (JSON.parseObject(result).get("returnValue")==null){
            return new ArrayList<AppCount>();
        }
        //3、解析结果集
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), AppCount.class);
    }

    /**
     * 调用datapark查询开发者日报按日
     * @param appKey
     * @param startTime
     * @param endTime
     * @param sortName
     * @param sortType
     * @return
     * @throws IOException
     */
    public List<AppCount> getAppDateVos(String appKey, String startTime, String endTime, String sortName, String sortType) throws IOException {
        //1、封装条件
        Map<String,Object> maps = Maps.newHashMap();
        if (StringUtils.isNotEmpty(appKey)){
            maps.put("appKey",appKey);
        }
        if (StringUtils.isNotEmpty(startTime)){
            maps.put("startTime",startTime);
        }
        if (StringUtils.isNotEmpty(endTime)){
            maps.put("endTime",endTime);
        }
        if (StringUtils.isNotEmpty(sortName)){
            maps.put("sortName",sortName);
        }
        if (StringUtils.isNotEmpty(sortType)){
            maps.put("sortType",sortType);
        }
        //2、调用datapark接口
        String result = restTemplateClient.getByParams(DATAPARKURL+"/app/date", maps, HttpMethod.POST, null);
        if (JSON.parseObject(result).get("returnValue")==null){
            return new ArrayList<AppCount>();
        }
        //3、解析结果集
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), AppCount.class);
    }

    /**
     * 调用开发者日报子链接按日
     * @param appKey
     * @param business
     * @param startTime
     * @param endTime
     * @param sortName
     * @param sortType
     * @return
     * @throws IOException
     */
    public List<AppCount> getAppAppBusinessDateVos(String appKey, String business, String startTime, String endTime, String sortName, String sortType) throws IOException {
        //1、封装条件
        Map<String,Object> maps = Maps.newHashMap();
        if (StringUtils.isNotEmpty(appKey)){
            maps.put("appKey",appKey);
        }
        if (StringUtils.isNotEmpty(business)){
            maps.put("business",business);
        }
        if (StringUtils.isNotEmpty(startTime)){
            maps.put("startTime",startTime);
        }
        if (StringUtils.isNotEmpty(endTime)){
            maps.put("endTime",endTime);
        }
        if (StringUtils.isNotEmpty(sortName)){
            maps.put("sortName",sortName);
        }
        if (StringUtils.isNotEmpty(sortType)){
            maps.put("sortType",sortType);
        }
        //2、调用datapark接口
        String result = restTemplateClient.getByParams(DATAPARKURL+"/app/business/date", maps, HttpMethod.POST, null);
        if (JSON.parseObject(result).get("returnValue")==null){
            return new ArrayList<>();
        }
        //3、解析结果集
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), AppCount.class);
    }

    public Page<TicketCountCommon> getAppTicketCount(String datetime,String appKey,Integer scene, String json,
                                                     Integer pageSize,Integer pageNum,String sortName, String sortType) throws IOException {
        //1、封装条件
        Map<String,Object> maps = Maps.newHashMap();
        if (StringUtils.isNotEmpty(datetime)){
            maps.put("datetime",datetime);
        }
        if (scene!=null&&StringUtils.isNotEmpty(scene.toString())){
            maps.put("scene",scene);
        }
        if (StringUtils.isNotEmpty(appKey)){
            maps.put("appkey",appKey);
        }
        if (StringUtils.isNotEmpty(json)){
            maps.put("json",json);
        }
       if (pageSize!=null){
            maps.put("pageSize",pageSize);
       }
        if (pageNum!=null){
            maps.put("pageNum",pageNum);
        }
        if (StringUtils.isNotEmpty(sortName)){
            maps.put("sortName",sortName);
        }
        if (StringUtils.isNotEmpty(sortType)){
            maps.put("sortType",sortType);
        }
        //3、解析结果集
        //2、调用datapark接口
        String result = restTemplateClient.getByParams(DATAPARKURL+"/app/ticket", maps, HttpMethod.POST, null);
        if (JSON.parseObject(result).get("returnValue")==null){
            return new Page<TicketCountCommon>();
        }
        //3、解析结果集
        Page page = JSON.parseObject(JSON.parseObject(result).get("returnValue").toString(), Page.class);
        if (CollectionUtils.isNotEmpty(page.getList())) {
            List<TicketCountCommon> list = JSON.parseArray(page.getList().toString(), TicketCountCommon.class);
            page.setList(list);
        }
        return page;
    }

    public List<TicketCountCommon> getAppTicketCount(String datetime,String appKey,Integer scene, String json) throws IOException {
        //1、封装条件
        Map<String,Object> maps = Maps.newHashMap();
        if (StringUtils.isNotEmpty(datetime)){
            maps.put("datetime",datetime);
        }
        if (scene!=null&&StringUtils.isNotEmpty(scene.toString())){
            maps.put("scene",scene);
        }
        if (StringUtils.isNotEmpty(appKey)){
            maps.put("appkey",appKey);
        }
        if (StringUtils.isNotEmpty(json)){
            maps.put("json",json);
        }
        //3、解析结果集
        //2、调用datapark接口
        String result = restTemplateClient.getByParams(DATAPARKURL+"/app/ticket/export", maps, HttpMethod.POST, null);
        if (JSON.parseObject(result).get("returnValue")==null){
            return new ArrayList<TicketCountCommon>();
        }
        //3、解析结果集
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), TicketCountCommon.class);
    }

    public List<TicketCountCommon> getAppTicketCountDate(String startTime, String endTime, String appKey, Long certificateid, String sortName, String sortType) throws IOException {
        //1、封装条件
        Map<String,Object> maps = Maps.newHashMap();
        if (StringUtils.isNotEmpty(startTime)){
            maps.put("startTime",startTime);
        }
        if (StringUtils.isNotEmpty(endTime)){
            maps.put("endTime",endTime);
        }
        if (StringUtils.isNotEmpty(appKey)){
            maps.put("appkey",appKey);
        }
        if (certificateid!=null){
            maps.put("certificateid",certificateid);
        }
        if (StringUtils.isNotEmpty(sortName)){
            maps.put("sortName",sortName);
        }
        if (StringUtils.isNotEmpty(sortType)){
            maps.put("sortType",sortType);
        }
        //3、解析结果集
        //2、调用datapark接口
        String result = restTemplateClient.getByParams(DATAPARKURL+"/app/ticket/date", maps, HttpMethod.POST, null);
        if (JSON.parseObject(result).get("returnValue")==null){
            return new ArrayList<TicketCountCommon>();
        }
        //3、解析结果集
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), TicketCountCommon.class);
    }

    public Page<TicketCountCommon> getAppBusinessTicketCount(String datetime, String appKey, String business,Integer scene, String json, Integer pageSize, Integer pageNum, String sortName, String sortType) throws IOException {

        //1、封装条件
        Map<String,Object> maps = Maps.newHashMap();
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(datetime)){
            maps.put("datetime",datetime);
        }
        if (scene!=null&&com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(scene.toString())){
            maps.put("scene",scene);
        }
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(appKey)){
            maps.put("appkey",appKey);
        }
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(business)){
            maps.put("business",business);
        }
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(json)){
            maps.put("json",json);
        }
        if (pageSize!=null){
            maps.put("pageSize",pageSize);
        }
        if (pageNum!=null){
            maps.put("pageNum",pageNum);
        }
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(sortName)){
            maps.put("sortName",sortName);
        }
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(sortType)){
            maps.put("sortType",sortName);
        }
        //2、调用datapark接口
        String result = restTemplateClient.getByParams(DATAPARKURL+"/app/ticket", maps, HttpMethod.POST, null);
        if (JSON.parseObject(result).get("returnValue")==null){
            return new Page<TicketCountCommon>();
        }
        Page page = JSON.parseObject(JSON.parseObject(result).get("returnValue").toString(), Page.class);
        if (CollectionUtils.isNotEmpty(page.getList())) {
            List<TicketCountCommon> list = JSON.parseArray(page.getList().toString(), TicketCountCommon.class);
            page.setList(list);
        }
        return page;
    }

    public List<TicketCountCommon> getAppBusinessTicketExport(String datetime, String appKey, String business,Integer scene, String json) throws IOException {
        //1、封装条件
        Map<String,Object> maps = Maps.newHashMap();
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(datetime)){
            maps.put("datetime",datetime);
        }
        if (scene!=null&&com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(scene.toString())){
            maps.put("scene",scene);
        }
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(appKey)){
            maps.put("appkey",appKey);
        }
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(business)){
            maps.put("business",business);
        }
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(json)){
            maps.put("json",json);
        }
        //2、调用datapark接口
        String result = restTemplateClient.getByParams(DATAPARKURL+"/app/ticket/export", maps, HttpMethod.POST, null);
        if (JSON.parseObject(result).get("returnValue")==null){
            return new ArrayList<TicketCountCommon>();
        }
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), TicketCountCommon.class);
    }

    public ResultModel appBusinessActivity(String json, String datetime, String appKey, String business, Integer pageSize, Integer pageNum, String sortName, String sortType) throws IOException {
        ResultModel<Pagination> resultModel = new ResultModel<>();
        Map<String,Object> parm = new HashMap<>();
        if (!StringUtils.isEmpty(json)){
            parm.put("json",json);
        }
        if (!StringUtils.isEmpty(datetime)){
            parm.put("datetime",datetime);
        }
        if (!StringUtils.isEmpty(appKey)){
            parm.put("appkey",appKey);
        }
        if (!StringUtils.isEmpty(business)){
            parm.put("business",business);
        }
        if (!StringUtils.isEmpty(sortName)){
            parm.put("sortName",sortName);
        }
        if (!StringUtils.isEmpty(sortType)){
            parm.put("sortType",sortType);
        }
        if (pageSize != null){
            parm.put("pageSize",pageSize);
        }
        if (pageNum != null){
            parm.put("pageNum",pageNum);
        }
        //调用DataPark接口
        String result = restTemplateClient.getByParams(DATAPARKURL+"/app/business/activity", parm, HttpMethod.POST, null);
        if (JSON.parseObject(result).get("returnValue")==null){
            resultModel.setReturnValue(null);
            return resultModel;
        }
        Page<ActivityCount> page = JSON.parseObject(JSON.parseObject(result).get("returnValue").toString(),
                Page.class);
        if (page.getList() == null) {
            resultModel.setReturnValue(null);
            return resultModel;
        }
        if (page.getSize() > 0) {
            List<ActivityCount> list = JSON.parseArray(page.getList().toString(), ActivityCount.class);
            page.setList(list);
        }
        Pagination pagination = new Pagination(page.getPageNum(), page.getSize(), page.getTotal().intValue(), page.getList());
        resultModel.setReturnValue(pagination);
        return resultModel;
    }


    public List<ActivityCount> appBusinessActivityExport(String json, String datetime, String appKey, String business) throws IOException {
        ResultModel<Pagination> resultModel = new ResultModel<>();
        Map<String,Object> parm = new HashMap<>();
        if (!StringUtils.isEmpty(json)){
            parm.put("json",json);
        }
        if (!StringUtils.isEmpty(datetime)){
            parm.put("datetime",datetime);
        }
        if (!StringUtils.isEmpty(appKey)){
            parm.put("appkey",appKey);
        }
        if (!StringUtils.isEmpty(business)){
            parm.put("business",business);
        }
        //调用DataPark接口
        String result = restTemplateClient.getByParams(DATAPARKURL+"/app/business/activity/export", parm, HttpMethod.POST, null);
        if (JSON.parseObject(result).get("returnValue")==null){
            return new ArrayList<ActivityCount>();
        }
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), ActivityCount.class);
    }


    /**
     * @description 根据时间和礼券id查找该礼券下面所有的广告位发券信息
     * @author hcmony
     * @time 2018/4/4
     * @param datetime
     * @param json
     * @return java.util.List<com.bxm.adsmanager.integration.datapark.model.TicketCountCommon>
     */
    public List<TicketCountCommon> getAppTicketCountWeight(String datetime, String json) throws IOException {

        //1、封装条件
        Map<String,Object> maps = Maps.newHashMap();
        if (StringUtils.isNotEmpty(datetime)){
            maps.put("datetime",datetime);
        }
        if (StringUtils.isNotEmpty(json)){
            maps.put("json",json);
        }
        //3、解析结果集
        //2、调用datapark接口
        String result = restTemplateClient.getByParams(DATAPARKURL+"/ticket/weight", maps, HttpMethod.POST, null);
        if (JSON.parseObject(result).get("returnValue")==null){
            return new ArrayList<TicketCountCommon>();
        }
        //3、解析结果集
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), TicketCountCommon.class);
    }
    /**
     * @description 根据不同角色查看到不同的数据和字段
     * @author hcmony
     * @time 2018/4/4
     * @return java.util.List<com.bxm.adsmanager.integration.datapark.model.TicketCountCommon>
     */
    public Page<AppCount> getAppCountVosSum(String startTime,String endTime,String sortName,String sortType,String appKeysJson ,int pageNum,int pageSize) throws Exception {
        //1、封装条件
        Map<String,Object> maps = Maps.newHashMap();
        if (StringUtils.isNotEmpty(startTime)){
            maps.put("startTime",startTime);
        }
        if (StringUtils.isNotEmpty(startTime)){
            maps.put("endTime",endTime);
        }
        if (StringUtils.isNotEmpty(sortName)){
            maps.put("sortName",sortName);
        }
        if (StringUtils.isNotEmpty(sortType)){
            maps.put("sortType",sortType);
        }
        if (StringUtils.isNotEmpty(appKeysJson)){
            maps.put("json",appKeysJson);
        }
        if (StringUtils.isNotEmpty(appKeysJson)){
            maps.put("pageNum",pageNum);
        }
        if (StringUtils.isNotEmpty(appKeysJson)){
            maps.put("pageSize",pageSize);
        }

        //2、调用datapark接口
        String result = restTemplateClient.getByParams(DATAPARKURL+"/app/getAppCountVosSum", maps, HttpMethod.POST, null);
        if (JSON.parseObject(result).get("returnValue")==null){
            return new Page<AppCount>();
        }
        //3、解析结果集
        Page page = JSON.parseObject(JSON.parseObject(result).get("returnValue").toString(), Page.class);

        if (CollectionUtils.isEmpty(page.getList())){
            new Page<AppCount>();
        }
        return page;
    }

    /**
     * @description 根据不同角色查看到不同的数据和字段
     * @author sunzhongshu
     * @time 2018/4/24
     * @return java.util.List<com.bxm.adsmanager.integration.datapark.model.TicketCountCommon>
     */
    public List<AppCount> appCountVosSumExport(String startTime,String endTime,String appKeysJson) throws Exception {
        //1、封装条件
        Map<String,Object> maps = Maps.newHashMap();
        if (StringUtils.isNotEmpty(startTime)){
            maps.put("startTime",startTime);
        }
        if (StringUtils.isNotEmpty(startTime)){
            maps.put("endTime",endTime);
        }
        if (StringUtils.isNotEmpty(appKeysJson)){
            maps.put("json",appKeysJson);
        }
        //2、调用datapark接口
        String result = restTemplateClient.getByParams(DATAPARKURL+"/app/appCountVosSumExport", maps, HttpMethod.POST, null);
        if (JSON.parseObject(result).get("returnValue")==null){
            return new ArrayList<AppCount>();
        }

        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), AppCount.class);
    }

}
